<?php

/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.0.0
 */

// no direct access
defined('ABSPATH') || die();

/** @var BLOGINA_Course $this */

global $product;

$post_id = get_the_ID();
$thumbnail_url = get_the_post_thumbnail_url($post_id, 'full');
$gallery = BLOGINA_Course::get_gallery();
$price = BLOGINA_Course::get_price(true);
$sessions = BLOGINA_Course::get_sessions();
$view_mode = BLOGINA_Course::get_view_type();
?>

<div class="blg-gallery lg:order-2 order-1 lg:mb-0 mb-4">
    <?php if ($gallery && is_array($gallery) && count($gallery) > 0): ?>
        <div class="single-course-swiper-container !max-h-[299px] overflow-hidden">
            <div class="swiper-wrapper">
                <?php foreach ($gallery as $image_id) : ?>
                    <div class="swiper-slide">
                        <div class="blg_course_grid">
                            <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                                <img loading="lazy" decoding="async" width="100%" height="100%"
                                     src="<?php echo esc_url(wp_get_attachment_url($image_id)); ?>" alt="">
                            </div>
                            <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>"
                               class="get_more">
                                <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7"
                                     xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 29 29"
                                     fill="none">
                                    <path opacity="0.4"
                                          d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z"
                                          fill="#3A4654"/>
                                    <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z"
                                          fill="#3A4654"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="xl:flex hidden gap-x-2 items-center">
                <div class="swiper-button-next">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path d="M20.8 32.5H11.2C3.2 32.5 0 29.3 0 21.3V11.7C0 3.7 3.2 0.5 11.2 0.5H20.8C28.8 0.5 32 3.7 32 11.7V21.3C32 29.3 28.8 32.5 20.8 32.5Z"
                              fill="white"/>
                        <path d="M13.9837 22.148L19.6157 16.5001L13.9837 10.8521" stroke="#3A4654"
                              stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <div class="swiper-button-prev">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path d="M11.2 32.5H20.8C28.8 32.5 32 29.3 32 21.3V11.7C32 3.7 28.8 0.5 20.8 0.5H11.2C3.2 0.5 0 3.7 0 11.7V21.3C0 29.3 3.2 32.5 11.2 32.5Z"
                              fill="white"/>
                        <path d="M18.0163 22.148L12.3843 16.5001L18.0163 10.8521" stroke="#3A4654"
                              stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </div>
        </div>
    <?php else: ?>
        <?php if (has_post_thumbnail()): ?>
            <div class="blg_course_grid">
                <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                    <img loading="lazy" decoding="async" width="100%" height="100%"
                         src="<?php echo esc_url($thumbnail_url); ?>" alt="">
                </div>
                <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>"
                   class="get_more">
                    <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg"
                         width="29" height="29" viewBox="0 0 29 29" fill="none">
                        <path opacity="0.4"
                              d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z"
                              fill="#3A4654"/>
                        <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z"
                              fill="#3A4654"/>
                    </svg>
                </a>
            </div>
        <?php else: ?>
            <div class="blg_course_grid">
                <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                    <img loading="lazy" decoding="async" width="100%" height="100%"
                         src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="">
                </div>
                <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>"
                   class="get_more">
                    <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg"
                         width="29" height="29" viewBox="0 0 29 29" fill="none">
                        <path opacity="0.4"
                              d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z"
                              fill="#3A4654"/>
                        <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z"
                              fill="#3A4654"/>
                    </svg>
                </a>
            </div>
        <?php endif; ?>
    <?php endif; ?>
    <?php BLOGINAC_Assets::footer('<style> .single-course-swiper-container { width: 100%; height: 100%; overflow: hidden; position: relative; /* Ensure arrows are positioned relative to the container */ } .swiper-wrapper { display: flex; transition-timing-function: ease; } .swiper-slide { width: 100%; flex-shrink: 0; box-sizing: border-box; } .swiper-button-next, .swiper-button-prev { color: #000; cursor: pointer; background: transparent; border: none; position: absolute; /* Position arrows */ top: 55%; /* Center vertically */ transform: translateY(-50%); /* Adjust for centering */ z-index: 999; /* Ensure arrows are above slides */ width: 32px; /* Adjust size */ height: 32px; } .swiper-button-next { right: 10px; /* Position to the right */ } .swiper-button-prev { left: 10px; /* Position to the left */ } .swiper-button-next svg, .swiper-button-prev svg { width: 100%; height: 100%; } .swiper-button-next.swiper-button-disabled svg path:first-of-type, .swiper-button-prev.swiper-button-disabled svg path:first-of-type { fill: var(--blg-color-primary500) /* Inactive color */ } .swiper-button-next.swiper-button-disabled svg path:nth-of-type(2), .swiper-button-prev.swiper-button-disabled svg path:nth-of-type(2) { stroke: #fff; /* Inactive stroke color for second path */ } </style>'); ?>
</div>

<?php if ($view_mode === 'slidermode'): ?>
    <div class="slider-mode-container hidden lg:order-2 order-1 lg:mb-0 mb-4 blg_course_grid"></div>
<?php endif; ?>

<script>
    jQuery(document).ready(function($) {
        var swiper = new Swiper('.single-course-swiper-container', {
            slidesPerView: 1,
            spaceBetween: 10,
            autoplay: true,
            pagination: false,
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
        });
    });
</script>

