<?php

/**
 * Edit address form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

defined('ABSPATH') || exit;

$page_title = ('billing' === $load_address) ? esc_html__('Billing address', 'woocommerce') : esc_html__('Shipping address', 'woocommerce');

do_action('woocommerce_before_edit_account_address_form'); ?>

<div class="mx-auto !bg-white  p-6 blg-shadow-sm rounded-[var(--blg-radius-3xl)] my-4">

	<?php if (!$load_address) : ?>
		<?php wc_get_template('myaccount/my-address.php'); ?>
	<?php else : ?>

		<div class="w-full my-6">
			<div class="flex justify-between items-center">
				<div class="flex flex-col gap-y-2">
					<h2 class="md:text-base text-md font-bold text-[var(--blg-color-primary500)]"><?php echo $page_title ?> </h2>
					<div class="h-[1px] bg-[#E4E4E4] w-full relative">
						<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
					</div>
				</div>
			</div>
		</div>
		<form method="post">
			<div class="woocommerce-address-fields">
				<?php do_action("woocommerce_before_edit_address_form_{$load_address}"); ?>

				<div class="woocommerce-address-fields__field-wrapper">
					<div class="address-fields">

						<?php
						foreach ($address as $key => $field) {
							woocommerce_form_field($key, $field, wc_get_post_data_by_key($key, $field['value']));
						}
						?>
					</div>
				</div>

				<?php do_action("woocommerce_after_edit_address_form_{$load_address}"); ?>

				<p class="flex items-center justify-end my-4">
					<button type="submit" class="blg-btn-secondary px-6 py-2 button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="save_address" value="<?php esc_attr_e('Save address', 'woocommerce'); ?>"><?php esc_html_e('Save address', 'woocommerce'); ?></button>
					<?php wp_nonce_field('woocommerce-edit_address', 'woocommerce-edit-address-nonce'); ?>
					<input type="hidden" name="action" value="edit_address" />
				</p>
			</div>

		</form>

	<?php endif; ?>

	<?php do_action('woocommerce_after_edit_account_address_form'); ?>
</div>