<?php

/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);
?>

<div class="dashboard-container">
<div class="w-full max-w-full mx-auto bg-[var(--blg-color-primary100)] lg:px-48 px-6 py-52  blg-shadow-sm rounded-[var(--blg-radius-3xl)] my-4">
	<div class="flex items-center justify-center flex-col gap-y-4 ">
			<span class="font-bold font-['Pinar'] md:text-lg text-sm text-[var(--blg-color-primary500)]">
				<?php
				printf(
					/* translators: 1: user display name 2: logout url */
					wp_kses(__('سلام  %1$s', 'woocommerce'), $allowed_html),
					esc_html($current_user->display_name),
				);
				?>
			</span>
			<p class="font-normal text-center text-[var(--blg-gray)] text-[15px]">از طریق پیشخوان حساب کاربری خود، می‌توانید فعالیت های اخیرتان را مشاهده، محصولات خریداری شده را مشاهده نمایید، همچنین قادر خواهید بود فایل های دانلود شده را مجددا دریافت نموده و جزییات حساب کاربری و کلمه عبور خود را ویرایش کنید.</p>
		</div>
	</div>
</div>

<?php
/**
 * My Account dashboard.
 *
 * @since 2.6.0
 */
do_action('woocommerce_account_dashboard');

/**
 * Deprecated woocommerce_before_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_before_my_account');

/**
 * Deprecated woocommerce_after_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_after_my_account');

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
