<?php
/**
 * The template for displaying product content within loops
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined('ABSPATH') || exit;

global $product;

// Ensure product visibility
if (empty($product) || !$product->is_visible()) {
    return;
}

// Get theme settings
$course_style = BLOGINA_Settings::get('blg_course_archive_style', 'style1');
$layout_type = BLOGINA_Settings::get('blg_course_archive_layout_type', 'grid');

// Determine template parts
$template_parts = [
    'grid' => [
        'style1' => 'templates/archive/archive-course',
        'style2' => 'templates/archive/archive-course-style2',
        'style3' => 'templates/archive/archive-course-style3',
    ],
    'list' => [
        'style1' => 'templates/archive/archive-course-list',
        'style2' => 'templates/archive/archive-course-list',
        'style3' => 'templates/archive/archive-course-list'
    ]
];

// Get the appropriate template part
$template_key = ($layout_type === 'grid') ? 'grid' : 'list';
$template_part = $template_parts[$template_key][$course_style] ?? $template_parts[$template_key]['style1'];

get_template_part($template_part);
