<?php

/**
 * Custom Checkout Coupon Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-coupon.php.
 *
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

if (! wc_coupons_enabled()) {
	return;
}

?>
<div class="woocommerce-form-coupon-toggle mb-4 bg-[var(--blg-color-primary100)] p-6 rounded-lg ">
	<div class="blg-coupon-dialouge">
		<?php wc_print_notice(
			apply_filters(
				'woocommerce_checkout_coupon_message',
				sprintf(
					'<div class="flex items-center gap-x-2 blg-icon"><span class="text-[var(--blg-color-primary500)] font-semibold">%1$s</span><a href="#" class="showcoupon line-through text-[var(--blg-gray)] font-semibold">%2$s</a></div>',
					esc_html__('Have a coupon?', 'woocommerce'),
					esc_html__('Click here to enter your code', 'woocommerce')
				),
				'notice'
			)
		); ?>
	</div>

	<form class="checkout_coupon woocommerce-form-coupon !py-2 !px-0 !my-4 !border-none" method="post" style="display: none;">
		<div class="flex items-center justify-between">
			<p class="form-row form-row-first !p-0 !m-0 !flex items-center">
				<label for="coupon_code" class="screen-reader-text"><?php esc_html_e('Coupon:', 'woocommerce'); ?></label>
				<input type="text" name="coupon_code" class="input-text rounded-lg w-full bg-white !max-w-[383px]" placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>" id="coupon_code" value="" />
			</p>

			<p class="form-row form-row-last !p-0 !m-0">
				<button type="submit" class="blg-btn-primary-filled" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>">
					<?php esc_html_e('Apply coupon', 'woocommerce'); ?>
				</button>
			</p>
		</div>

		<div class="clear"></div>
	</form>
</div>

<script>
	jQuery(document).ready(function($) {
		$('.blg-icon').prepend('<svg xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none"><circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" /></svg>');
	});
</script>