<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined('ABSPATH') || exit;

get_header('shop');

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content');

/**
 * Hook: woocommerce_shop_loop_header.
 *
 * @since 8.6.0
 *
 * @hooked woocommerce_product_taxonomy_archive_header - 10
 */
do_action('woocommerce_shop_loop_header');

if (woocommerce_product_loop()) {

    /**
     * Hook: woocommerce_before_shop_loop.
     *
     * @hooked woocommerce_output_all_notices - 10
     * @hooked woocommerce_result_count - 20
     * @hooked woocommerce_catalog_ordering - 30
     */
    do_action('woocommerce_before_shop_loop');

    woocommerce_product_loop_start();
?>
    <?php $sidebar = BLOGINA_Settings::get('blg_archive_course_layout'); ?>

    <?php if ($sidebar != 'full-width') : ?>
        <div class="lg:col-span-3 <?php echo $sidebar == 'sidebar-left' ? 'order-1' : ''; ?> col-span-12">
            <?php do_action('woocommerce_sidebar'); ?>
        </div>
    <?php endif; ?>

    <?php
    $layout_type = BLOGINA_Settings::get('blg_course_archive_layout_type', 'grid');
    $grid_columns_style1 = BLOGINA_Settings::get('blg_course_archive_grid_columns', 3);
    $grid_columns_style2 = BLOGINA_Settings::get('blg_course_archive_grid_columns_style2', 2);
    ?>

    <div class="<?php echo ($sidebar != 'full-width') ? 'lg:col-span-9' : ''; ?> col-span-12 blg-post-content">
        <?php if ($layout_type === 'grid') : ?>
            <div class="grid <?php echo BLOGINA_Settings::get('blg_course_archive_style') == 'style2' ? 'lg:grid-cols-'. esc_attr($grid_columns_style2) : 'lg:grid-cols-'.esc_attr($grid_columns_style1); ?> md:grid-cols-2 grid-cols-1 gap-y-6 gap-x-6">
        <?php else : ?>
            <div class="space-y-6">
        <?php endif; ?>
                <?php
                /**
                 * Hook: woocommerce_sidebar.
                 *
                 * @hooked woocommerce_get_sidebar - 10
                 */

                if (wc_get_loop_prop('total')) {
                    while (have_posts()) {
                        the_post();

                        /**
                         * Hook: woocommerce_shop_loop.
                         */
                        do_action('woocommerce_shop_loop');

                        wc_get_template_part('content', 'product');
                    }
                }
                ?>
                </div>
            </div>
        <?php

        woocommerce_product_loop_end();

        /**
         * Hook: woocommerce_after_shop_loop.
         *
         * @hooked woocommerce_pagination - 10
         */
        do_action('woocommerce_after_shop_loop');
    } else {
        /**
         * Hook: woocommerce_no_products_found.
         *
         * @hooked wc_no_products_found - 10
         */
        do_action('woocommerce_no_products_found');
    }

    /**
     * Hook: woocommerce_after_main_content.
     *
     * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
     */
    do_action('woocommerce_after_main_content');

    get_footer('shop');
