<?php
$post_id = get_the_ID();
$blg_television = BLOGINA_TELEVISION::get_television_meta();
$gallery = BLOGINA_TELEVISION::get_gallery();
$video = BLOGINA_TELEVISION::get_video();
$video_url = wp_get_attachment_url($video);
$date = BLOGINA_JALALI::get_jalali_date_info();
$display_gallery = BLOGINA_Settings::get('blg_single_television_show_galley');
$display_meta = BLOGINA_Settings::get('blg_single_television_show_posts_meta');

?>
<div class="flex justify-between items-center my-8 mt-12">
    <div class="flex flex-col gap-y-2">
        <?php the_title('<h1 class="text-xl font-bold text-[var(--blg-color-primary500)]">', '</h1>'); ?> </h1>
        <div class="h-[1px] bg-[#E4E4E4] w-full relative">
            <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
        </div>
    </div>
</div>

<article id="post-<?php the_ID(); ?>" <?php post_class(''); ?>>
    <div class="bg-white blg-shadow-sm lg:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] p-6 <?php echo $display_gallery ? 'pb-24':''; ?> relative">
        <figure class="relative">
            <?php if ($video_url) : ?>
                <div class="relative w-full h-full aspect-video lg:rounded-[32px] rounded-[var(--blg-radius-xl)] overflow-hidden lg:min-h-[657px] lg:max-h-[657px]">
                    <!-- Cover Image -->
                    <div class="absolute inset-0 bg-cover bg-center lg:rounded-[32px] rounded-[var(--blg-radius-xl)] cursor-pointer"
                        style="background-image: url('<?php echo esc_url(wp_get_attachment_url(get_post_thumbnail_id())); ?>');">
                        <button aria-label="play"
                            class="absolute inset-0 flex items-center justify-center w-full h-full bg-black bg-opacity-40 rounded-[32px]">
                            <svg class="bg-white p-[9px] rounded-lg lg:w-12 lg:h-12 w-8 h-8 transition duration-300 hover:fill-white hover:bg-[var(--blg-color-secondary200)]"
                                xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"
                                fill="currentColor">
                                <path d="M6.16815 12.6368V15.3068C6.16815 18.6168 8.51815 19.9768 11.3881 18.3168L13.6981 16.9768L16.0081 15.6368C18.8781 13.9768 18.8781 11.2668 16.0081 9.60677L13.6981 8.26677L11.3881 6.92677C8.51815 5.29677 6.16815 6.64677 6.16815 9.96677V12.6368Z" />
                            </svg>
                        </button>
                    </div>
                    <!-- Video -->
                    <video id="blg_video" class="plyr absolute inset-0 w-full h-full hidden object-cover rounded-[32px]"
                        controls>
                        <source src="<?php echo $video_url; ?>" type="video/mp4">
                        <?php esc_html_e('Your browser does not support the video tag.', BLOGINA_TEXT_DOMAIN); ?>
                    </video>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            var cover = document.querySelector('[style*="background-image"]');
                            var video = document.getElementById('blg_video');

                            cover.addEventListener('click', function() {
                                cover.classList.add('hidden'); // Hide the cover image
                                video.classList.remove('hidden'); // Show the video
                                video.play();
                            });
                        });
                    </script>
                </div>
            <?php else : ?>
                <?php if (has_post_thumbnail()): ?>
                    <img width="100%" height="100%"
                        class="relative w-full h-full object-cover rounded-[32px] overflow-hidden !min-h-[250px] !max-h-[250px]"
                        src=" <?php echo esc_url(wp_get_attachment_url(get_post_thumbnail_id())); ?>" alt="">

                <?php else : ?>
                    <img width="100%" height="250" class="w-full h-[250px] object-cover rounded-lg min-h-[657px]"
                        src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/default.webp"
                        alt="<?php the_title_attribute(); ?>">
                <?php endif; ?>
            <?php endif; ?>
        </figure>

        <?php if($display_gallery): ?>
            <div class="blg-gallery lg:order-2 order-1 lg:mb-0 mb-4 lg:px-44 px-2 absolute left-0 right-0 -bottom-32">
            <?php if ($gallery && is_array($gallery) && count($gallery) > 0): ?>
                <div class="relative">
                    <div class="swiper-container w-full md:h-auto h-full overflow-x-hidden overflow-y-hidden px-[10px] py-5">
                        <div class="swiper-wrapper">
                            <?php foreach ($gallery as $image_id) : ?>
                                <div class="swiper-slide">
                                    <div class="relative w-full max-w-[168px] max-h-[168px] min-w-[168px] min-h-[168px] bg-white shadow-sm md:rounded-[var(--blg-radius-2xl)] rounded-[var(--blg-radius-xl)] flex justify-center items-center overflow-hidden">
                                        <img width="100%" height="100%"
                                            src="<?php echo esc_url(wp_get_attachment_url($image_id)); ?>"
                                            alt="<?php echo esc_attr(get_post_meta($image_id, '_wp_attachment_image_alt', true)); ?>"
                                            class="min-w-[168px] min-h-[168px] w-full h-full object-cover md:rounded-[var(--blg-radius-2xl)] rounded-[var(--blg-radius-xl)] ">
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="lg:flex hidden gap-x-2 items-center">
                        <div class="swiper-button-next">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                                fill="none">
                                <path d="M20.8 32.5H11.2C3.2 32.5 0 29.3 0 21.3V11.7C0 3.7 3.2 0.5 11.2 0.5H20.8C28.8 0.5 32 3.7 32 11.7V21.3C32 29.3 28.8 32.5 20.8 32.5Z"
                                    fill="white" />
                                <path d="M13.9837 22.148L19.6157 16.5001L13.9837 10.8521" stroke="#3A4654"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                        <div class="swiper-button-prev">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                                fill="none">
                                <path d="M11.2 32.5H20.8C28.8 32.5 32 29.3 32 21.3V11.7C32 3.7 28.8 0.5 20.8 0.5H11.2C3.2 0.5 0 3.7 0 11.7V21.3C0 29.3 3.2 32.5 11.2 32.5Z"
                                    fill="white" />
                                <path d="M18.0163 22.148L12.3843 16.5001L18.0163 10.8521" stroke="#3A4654"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </div>
                </div>
                <?php BLOGINAC_Assets::footer('<style> .swiper-wrapper { display: flex; transition-timing-function: ease; } .swiper-slide {flex-shrink: 0; box-sizing: border-box; } .swiper-button-next, .swiper-button-prev { color: #000; cursor: pointer; background: transparent; border: none; position: absolute; top: 50%; transform: translateY(-50%); z-index: 999; width: 44px; height: 44px; } .swiper-button-next { right: -76px;top:120px; } .swiper-button-prev { left: -76px;top:120px;  } .swiper-button-next svg, .swiper-button-prev svg { width: 100%; height: 100%; } .swiper-button-next svg path:first-of-type, .swiper-button-prev svg path:first-of-type{ fill:var(--blg-color-primary400); } .swiper-button-next.swiper-button-disabled svg path:first-of-type, .swiper-button-prev.swiper-button-disabled svg path:first-of-type { fill: var(--blg-color-primary500); } .swiper-button-next.swiper-button-disabled svg path:nth-of-type(2), .swiper-button-prev.swiper-button-disabled svg path:nth-of-type(2) { stroke: #fff; } </style>'); ?>
                <?php BLOGINAC_Assets::footer("
<script>
    document.addEventListener('DOMContentLoaded', function () {
        var swiper = new Swiper('.swiper-container', {
            slidesPerView: 2,
            spaceBetween: 20,
            pagination: false,
            autoplay: true,
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            breakpoints: {
                320: { slidesPerView: 1, spaceBetween: 10 },  // Small phones
                375: { slidesPerView: 2, spaceBetween: 30 },  // Larger phones
                425: { slidesPerView: 2, spaceBetween: 15 },  // Larger phones
                600: { slidesPerView: 2, spaceBetween: 15 },  // Tablets portrait
                768: { slidesPerView: 3, spaceBetween: 20 },  // Tablets landscape
                1024: { slidesPerView: 3, spaceBetween: 25 }, // Small laptops
                1200: { slidesPerView: 4, spaceBetween: 25 }, // Laptops
                1440: { slidesPerView: 5, spaceBetween: 30 }, // Desktops
                1600: { slidesPerView: 5, spaceBetween: 30 }, // Large desktops
            },
        });
    });
</script>
"); ?>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>


    <div class="<?php echo $display_gallery ? 'pt-36':'pt-6'; ?>">
        <div class="grid lg:grid-cols-3 grid-cols-1 lg:gap-x-6 gap-y-6">
            <?php if($display_meta): ?>
                <div class="col-span-1 flex max-md:flex-col flex-row lg:flex-col lg:gap-y-6 max-md:gap-y-6 lg:gap-x-0 gap-x-6">
                <div class="w-full bg-white blg-shadow-sm md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] md:py-10 px-6 py-8">
                    <div class="flex items-center gap-x-4 w-full">
                        <div class="bg-[var(--blg-color-primary500)] rounded-md p-5">
                            <svg xmlns="http://www.w3.org/2000/svg" width="39" height="40" viewBox="0 0 39 40"
                                fill="none">
                                <path opacity="0.4"
                                    d="M10.7663 36.6666H28.233C32.833 36.6666 34.6663 33.85 34.883 30.4166L35.7496 16.65C35.983 13.05 33.1163 9.99998 29.4996 9.99998C28.483 9.99998 27.5496 9.41665 27.083 8.51665L25.883 6.09998C25.1163 4.58331 23.1163 3.33331 21.4163 3.33331H17.5996C15.883 3.33331 13.883 4.58331 13.1163 6.09998L11.9163 8.51665C11.4496 9.41665 10.5163 9.99998 9.49963 9.99998C5.88296 9.99998 3.01629 13.05 3.24963 16.65L4.11629 30.4166C4.31629 33.85 6.16629 36.6666 10.7663 36.6666Z"
                                    fill="white" />
                                <path d="M22 14.5833H17C16.3167 14.5833 15.75 14.0166 15.75 13.3333C15.75 12.65 16.3167 12.0833 17 12.0833H22C22.6833 12.0833 23.25 12.65 23.25 13.3333C23.25 14.0166 22.6833 14.5833 22 14.5833Z"
                                    fill="white" />
                                <path d="M19.5005 30.2167C22.6117 30.2167 25.1339 27.6945 25.1339 24.5833C25.1339 21.4721 22.6117 18.95 19.5005 18.95C16.3893 18.95 13.8672 21.4721 13.8672 24.5833C13.8672 27.6945 16.3893 30.2167 19.5005 30.2167Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <div class="flex flex-col gap-y-3">
                            <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold">سازنده ویدیو</h4>
                            <div class="flex gap-x-4 items-center text-[var(--blg-gray)]">
                                <?php echo BLOGINA_User::get_avatar(get_the_ID(), 28, 'rounded-full'); ?>
                                <span class="md:text-sm text-xs font-medium text-[var(--blg-color-primary)]"><?php echo BLOGINA_Post::posted_by(); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="w-full bg-white blg-shadow-sm md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] md:py-10 px-6 py-8">
                    <div class="flex items-center gap-x-4 w-full">
                        <div class="bg-[var(--blg-color-primary500)] rounded-md p-5">
                            <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41"
                                fill="none">
                                <path opacity="0.4"
                                    d="M34.1667 16.81C35.1063 16.81 35.875 17.5787 35.875 18.5183V29.0417C35.875 34.1667 33.3125 37.5833 27.3333 37.5833H13.6667C7.6875 37.5833 5.125 34.1667 5.125 29.0417V18.5183C5.125 17.5787 5.89375 16.81 6.83333 16.81H34.1667Z"
                                    fill="white" />
                                <path d="M28.6147 6.08168V3.41669C28.6147 2.71627 28.0338 2.13544 27.3334 2.13544C26.633 2.13544 26.0522 2.71627 26.0522 3.41669V5.97919H14.948V3.41669C14.948 2.71627 14.3672 2.13544 13.6667 2.13544C12.9663 2.13544 12.3855 2.71627 12.3855 3.41669V6.08168C7.77299 6.50877 5.53507 9.25918 5.1934 13.3421C5.15923 13.8375 5.56923 14.2475 6.04757 14.2475H34.9526C35.448 14.2475 35.858 13.8204 35.8068 13.3421C35.4651 9.25918 33.2272 6.50877 28.6147 6.08168Z"
                                    fill="white" />
                                <path d="M26.7524 31.5529L25.4882 30.2888C26.1374 29.2979 26.5303 28.1021 26.5303 26.8209C26.5303 23.3359 23.6945 20.5 20.2095 20.5C16.7245 20.5 13.8887 23.3359 13.8887 26.8209C13.8887 30.3059 16.7245 33.1417 20.2095 33.1417C21.4907 33.1417 22.6866 32.7488 23.6774 32.0996L24.9416 33.3637C25.1978 33.62 25.5224 33.7396 25.847 33.7396C26.1716 33.7396 26.4962 33.62 26.7524 33.3637C27.2478 32.8683 27.2478 32.0483 26.7524 31.5529Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <div class="flex flex-col gap-y-3 w-full">
                            <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"> تاریخ انتشار
                                ویدیو</h4>
                            <div class="flex items-center justify-start md:gap-x-10 gap-x-4 w-full">
                                <div class="flex gap-x-1 items-center">
                                    <span class="text-[var(--blg-gray)] font-normal md:text-base text-[15px]"><?php echo $date['season']; ?></span>
                                    <span class="text-[var(--blg-gray)] font-normal md:text-base text-[15px]"><?php echo $date['year']; ?></span>
                                </div>
                                <div class="w-[1px] h-4 bg-[var(--blg-color-primary500)] opacity-40"></div>
                                <div class="flex gap-x-1 items-center">
                                    <span class="text-[var(--blg-gray)] font-normal md:text-base text-[15px]"><?php echo $date['day']; ?></span>
                                    <span class="text-[var(--blg-gray)] font-normal md:text-base text-[15px]"><?php echo $date['month']; ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div class="entry-content blg-single-entry-content <?php echo $display_meta ? 'col-span-2' : 'col-span-3'; ?> bg-white gap-x-8 gap-y-2 p-6 blg-shadow-sm md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] overflow-hidden">
                <?php
                the_content(sprintf(
                    wp_kses(__('Continue reading<span class="screen-reader-text"> "%s"</span>', BLOGINA_TEXT_DOMAIN), array(
                        'span' => array(
                            'class' => [],
                        ),
                    )),
                    wp_kses_post(get_the_title())
                ));

                ?>
            </div>
        </div>
    </div>
</article>
