<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINA_Course $this */

global $product;

$post_id = get_the_ID();
$price = BLOGINA_Course::get_price(true);
$students_text = BLOGINA_Settings::get('blg_single_course_bought_text');

?>
<div class="xl:col-span-3 col-span-12 w-full">
    <div class="bg-white blg-shadow-sm rounded-[var(--blg-radius-3xl)] p-3 flex flex-col gap-y-3 <?php echo BLOGINA_Settings::get('blg_single_course_sticky_sidebar') ? 'blg-sticky-sidebar' : ''; ?>">
        <div class="grid md:grid-cols-2 grid-cols-1 gap-x-3 gap-y-3">
            <div class="w-full bg-[#F1F4F7] rounded-[var(--blg-radius-lg)] pr-4 pl-7 py-3">
                <div class="flex gap-x-3 items-center w-full">
                    <div class="">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25"
                             fill="none">
                            <path d="M22 8.3222V16.7022C22 19.5122 20.71 21.4422 18.44 22.1722C17.78 22.4022 17.02 22.5122 16.19 22.5122H7.81C6.98 22.5122 6.22 22.4022 5.56 22.1722C3.29 21.4422 2 19.5122 2 16.7022V8.3222C2 4.6822 4.17 2.51221 7.81 2.51221H16.19C19.83 2.51221 22 4.6822 22 8.3222Z"
                                  fill="#DBE3EA" />
                            <path d="M18.4396 22.1722C17.7796 22.4022 17.0196 22.5122 16.1896 22.5122H7.80957C6.97957 22.5122 6.21957 22.4022 5.55957 22.1722C5.90957 19.5322 8.66957 17.4822 11.9996 17.4822C15.3296 17.4822 18.0896 19.5322 18.4396 22.1722Z"
                                  fill="#3A4654" />
                            <path opacity="0.4"
                                  d="M15.5799 12.0922C15.5799 14.0722 13.9799 15.6822 11.9999 15.6822C10.0199 15.6822 8.41992 14.0722 8.41992 12.0922C8.41992 10.1122 10.0199 8.51221 11.9999 8.51221C13.9799 8.51221 15.5799 10.1122 15.5799 12.0922Z"
                                  fill="#3A4654" />
                        </svg>
                    </div>
                    <div class="flex flex-col">
                        <span class="text-[var(--blg-color-primary500)] font-extrabold text-[18px]"><?php echo BLOGINA_Course::get_students_count($post_id); ?></span>
                        <span class="text-[var(--blg-gray)] font-normal text-[15px]">دانشجو</span>
                    </div>
                </div>
            </div>
            <div class="w-full bg-[#F1F4F7] rounded-[var(--blg-radius-lg)] px-4 py-3">
                <div class="flex gap-x-3 items-center w-full">
                    <div class="">
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"
                             fill="none">
                            <path d="M16.69 2.51221H8.31C4.67 2.51221 2.5 4.68221 2.5 8.32221V16.6922C2.5 20.3422 4.67 22.5122 8.31 22.5122H16.68C20.32 22.5122 22.49 20.3422 22.49 16.7022V8.32221C22.5 4.68221 20.33 2.51221 16.69 2.51221Z"
                                  fill="#DBE3EA" />
                            <path d="M14.7602 12.5122L13.2502 11.9822V8.59221H13.6102C14.4202 8.59221 15.0802 9.30221 15.0802 10.1722C15.0802 10.5822 15.4202 10.9222 15.8302 10.9222C16.2402 10.9222 16.5802 10.5822 16.5802 10.1722C16.5802 8.47221 15.2502 7.09221 13.6102 7.09221H13.2502V6.51221C13.2502 6.10221 12.9102 5.76221 12.5002 5.76221C12.0902 5.76221 11.7502 6.10221 11.7502 6.51221V7.09221H11.1002C9.62016 7.09221 8.41016 8.34221 8.41016 9.87221C8.41016 11.6622 9.45016 12.2322 10.2402 12.5122L11.7502 13.0422V16.4222H11.3902C10.5802 16.4222 9.92016 15.7122 9.92016 14.8422C9.92016 14.4322 9.58016 14.0922 9.17016 14.0922C8.76016 14.0922 8.42016 14.4322 8.42016 14.8422C8.42016 16.5422 9.75016 17.9222 11.3902 17.9222H11.7502V18.5122C11.7502 18.9222 12.0902 19.2622 12.5002 19.2622C12.9102 19.2622 13.2502 18.9222 13.2502 18.5122V17.9322H13.9002C15.3802 17.9322 16.5902 16.6822 16.5902 15.1522C16.5802 13.3522 15.5402 12.7822 14.7602 12.5122ZM10.7402 11.1022C10.2302 10.9222 9.92016 10.7522 9.92016 9.88221C9.92016 9.17221 10.4502 8.60221 11.1102 8.60221H11.7602V11.4622L10.7402 11.1022ZM13.9002 16.4322H13.2502V13.5722L14.2602 13.9222C14.7702 14.1022 15.0802 14.2722 15.0802 15.1422C15.0802 15.8522 14.5502 16.4322 13.9002 16.4322Z"
                                  fill="#3A4654" />
                        </svg>
                    </div>
                    <div class="flex flex-col">
                        <span class="text-[var(--blg-color-primary500)] font-extrabold text-[18px]"><?php echo $price['sale_price'] ?? $price['regular_price']; ?></span>
                        <?php if (!BLOGINA_Course::is_product_free($product)): ?>
                            <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo BLOGINA_Course::get_currency(); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="flex gap-x-4 items-center border-t border-gray-100 pt-3">
            <?php echo BLOGINA_User::get_avatar(get_the_ID(), 53, 'rounded-full', 'mentor'); ?>
            <div class="flex flex-col gap-y-2">
                <span class="md:text-base text-sm font-semibold text-[#2F2F2F]"><?php echo BLOGINA_Course::get_mentor(); ?></span>
                <span class="md:text-[15px] text-xs font-normal text-[var(--blg-gray)]"><?php echo BLOGINA_Course::get_user_role(); ?></span>
            </div>
        </div>
        <div class="border-t border-gray-100 pt-2 w-full">
            <?php if (!BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id)) : ?>
                <?php woocommerce_template_single_add_to_cart(); ?>
            <?php else: ?>
                <button type="button" class="blg-btn-add-to-cart blg-btn-secondary px-6 py-4 !min-w-full">
                    <?php esc_html_e($students_text); ?>
                </button>
            <?php endif; ?>
        </div>
    </div>
</div>

