<?php

/**
 * Template part for displaying sub-footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package blogina
 */

?>
<div class="text-center w-full bg-[var(--blg-color-primary400)] py-[18px] max-xl:px-2 mt-16">
    <div class="flex items-center justify-between md:flex-row flex-col gap-y-4 w-full blogina-container px-4">
        <div class="flex items-center md:flex-row flex-col">
            <div class="site-branding">
                <?php
                if (has_custom_logo()) echo BLOGINA_Theme::logo();
                else {
                    $blogname = get_bloginfo('name');
                    if (trim($blogname)) {
                        if ((is_front_page() or is_home()) and !is_page()) echo '<h1><a href="' . esc_url(home_url()) . '"><img width="100%" height="100%" alt="footer-site-logo" src="' . BLOGINA_Settings::get('site_logo')['url'] .'"/></a></h1>';
                        else echo '<a href="' . esc_url(home_url()) . '"><img width="100%" height="100%" alt="footer-site-logo" src="' . BLOGINA_Settings::get('site_logo')['url'] .'"/></a>';
                    }
                }
                ?>
            </div>
        </div>
        <div class="md:hidden flex w-full h-[1px] bg-[var(--blg-color-primary500)] opacity-15"></div>
        <a href="tel:<?php echo BLOGINA_Settings::get('blg_phone_number'); ?>" class="w-auto flex items-center md:gap-x-0 gap-x-3">
            <div class="flex items-center font-semibold md:text-[22px] text-xl justify-center lg:px-4 px-1 gap-x-4">
                <span><?php echo BLOGINA_Settings::get('blg_phone_number'); ?></span>
            </div>
            <div class="w-[1px] h-16 bg-[var(--blg-color-primary300)]"></div>
            <div class="flex items-center lg:pr-4 max-lg:px-2 gap-x-2">
                <div class="p-[10px] bg-[var(--blg-color-primary500)] rounded-[var(--blg-radius-lg)]">
                    <svg xmlns="http://www.w3.org/2000/svg" width="45" height="44" viewBox="0 0 45 44" fill="none">
                        <path d="M40.5086 33.6048C40.5086 34.2648 40.362 34.9432 40.0503 35.6032C39.7386 36.2632 39.3353 36.8865 38.8036 37.4732C37.9053 38.4632 36.9153 39.1782 35.797 39.6365C34.697 40.0948 33.5053 40.3332 32.222 40.3332C30.352 40.3332 28.3536 39.8932 26.2453 38.9948C24.137 38.0965 22.0286 36.8865 19.9386 35.3648C17.8303 33.8248 15.832 32.1198 13.9253 30.2315C12.037 28.3248 10.332 26.3265 8.81031 24.2365C7.30697 22.1465 6.09697 20.0565 5.21697 17.9848C4.33697 15.8948 3.89697 13.8965 3.89697 11.9898C3.89697 10.7432 4.11697 9.5515 4.55697 8.4515C4.99697 7.33317 5.69364 6.3065 6.66531 5.38984C7.83864 4.23484 9.12197 3.6665 10.4786 3.6665C10.992 3.6665 11.5053 3.7765 11.9636 3.9965C12.4403 4.2165 12.862 4.5465 13.192 5.02317L17.4453 11.0182C17.7753 11.4765 18.0136 11.8982 18.1786 12.3015C18.3436 12.6865 18.4353 13.0715 18.4353 13.4198C18.4353 13.8598 18.307 14.2998 18.0503 14.7215C17.812 15.1432 17.4636 15.5832 17.0236 16.0232L15.6303 17.4715C15.4286 17.6732 15.337 17.9115 15.337 18.2048C15.337 18.3515 15.3553 18.4798 15.392 18.6265C15.447 18.7732 15.502 18.8832 15.5386 18.9932C15.8686 19.5982 16.437 20.3865 17.2436 21.3398C18.0686 22.2932 18.9486 23.2648 19.902 24.2365C20.892 25.2082 21.8453 26.1065 22.817 26.9315C23.7703 27.7382 24.5586 28.2882 25.182 28.6182C25.2736 28.6548 25.3836 28.7098 25.512 28.7648C25.6586 28.8198 25.8053 28.8382 25.9703 28.8382C26.282 28.8382 26.5203 28.7282 26.722 28.5265L28.1153 27.1515C28.5736 26.6932 29.0136 26.3448 29.4353 26.1248C29.857 25.8682 30.2786 25.7398 30.737 25.7398C31.0853 25.7398 31.452 25.8132 31.8553 25.9782C32.2586 26.1432 32.6803 26.3815 33.1386 26.6932L39.207 31.0015C39.6836 31.3315 40.0136 31.7165 40.2153 32.1748C40.3986 32.6332 40.5086 33.0915 40.5086 33.6048Z" fill="#DBE3EA"/>
                        <path opacity="0.5" d="M34.1471 16.4997C34.1471 15.3997 33.2855 13.713 32.0021 12.338C30.8288 11.073 29.2705 10.083 27.7305 10.083" stroke="#DBE3EA" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
                        <path opacity="0.5" d="M40.5638 16.4998C40.5638 9.40484 34.8255 3.6665 27.7305 3.6665" stroke="#DBE3EA" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </div>
        </a>

    </div>
</div>
