<?php

/**
 * Template part for displaying sub-footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package blogina
 */

$footer1 = is_active_sidebar('footer-1');
$footer2 = is_active_sidebar('footer-2');
$footer3 = is_active_sidebar('footer-3');
$footer4 = is_active_sidebar('footer-4');
?>
<?php if ($footer1 || $footer2 || $footer3 || $footer4): ?>
    <div class="blogina-container px-4 site-main-footer mx-auto">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-6 md:gap-8">
            <?php if ($footer1): ?>
                <div class="site-footer-1 col-span-1 lg:col-span-4 mb-8 md:mb-0">
                    <?php dynamic_sidebar('footer-1'); ?>
                </div>
            <?php endif; ?>

            <div class="col-span-1 lg:col-span-4 flex sm:justify-around justify-center gap-y-4 gap-x-8 w-full mb-8 md:mb-0">
                <?php if ($footer2): ?>
                    <div class="site-footer-2">
                        <?php dynamic_sidebar('footer-2'); ?>
                    </div>
                <?php endif; ?>

                <?php if ($footer3): ?>
                    <div class="site-footer-3">
                        <?php dynamic_sidebar('footer-3'); ?>
                    </div>
                <?php endif; ?>
            </div>

            <?php if ($footer4): ?>
                <div class="site-footer-4 col-span-1 lg:col-span-4 mb-8 md:mb-0">
                    <?php dynamic_sidebar('footer-4'); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>
