<?php

/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Blogina
 */
if (!is_active_sidebar('sidebar-1')) {
    return;
}
$sticky_archive_sidebar = BLOGINA_Settings::get('blg_blog_sticky_sidebar') ? 'blg-sticky-sidebar':'';
$sticky_tv_sidebar = BLOGINA_Settings::get('blg_television_sticky_sidebar') ? 'blg-sticky-sidebar':'';
$sticky_product_sidebar = BLOGINA_Settings::get('blg_course_sticky_sidebar') ? 'blg-sticky-sidebar':'';
?>
<aside role="complementary" id="secondary" class="widget-area flex flex-col gap-y-4 <?php echo is_post_type_archive('blogina-television') ? $sticky_tv_sidebar : (is_woocommerce() || is_shop() || is_product_category() || is_product_tag() ? $sticky_product_sidebar : $sticky_archive_sidebar); ?>">
<?php if (is_post_type_archive('blogina-television')): ?>
        <?php dynamic_sidebar('sidebar-television'); ?>
    <?php elseif (is_woocommerce() || is_shop() || is_product_category() || is_product_tag()) : ?>
        <?php if (is_active_sidebar('sidebar-woocommerce')) dynamic_sidebar('sidebar-woocommerce'); ?>
    <?php else: ?>
        <?php dynamic_sidebar('sidebar-1'); ?>
    <?php endif;?>
</aside>