<?php

/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blogina
 */
get_header();
do_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

?>

<div class="blogina-header">
	<?php // the_archive_description('<div class="archive-description">', '</div>');
	?>
	<div class="w-full mb-6 mt-10">
		<div class="flex justify-between items-center">
			<div class="flex flex-col gap-y-2 font-bold">
				<div class="flex gap-x-2">
					<?php printf(esc_html__('Search Results for: %s', BLOGINA_TEXT_DOMAIN), '<span class="font-bold text-xl">' . get_search_query() . '</span>'); ?>
				</div>
				<div class="h-[1px] bg-[#E4E4E4] w-full relative">
					<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="grid grid-cols-12 gap-x-6 py-4 gap-y-4">
	<div class="lg:col-span-12 col-span-12 blg-post-content">

		<div class="grid lg:grid-cols-4 md:grid-cols-3 grid-cols-1 gap-y-6 gap-x-6">
			<?php
			if (have_posts()):
				/* Start the Loop */
				while (have_posts()) {
					the_post();

					/*
						 * Include the Post-Type-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
						 */
					get_template_part('templates/content', 'search');
				}

			else:

				get_template_part('templates/content', 'none');

			endif;
			?>

		</div>
		<?php echo BLOGINA_Pagination::paginate($wp_query); ?>
	</div>

</div>

<?php
get_footer();
