<?php
/**
 * Blogina Theme
 * @package Blogina
 */

// Include Theme Bootstrap
require_once get_template_directory() . '/includes/class/bootstrap.php';
require_once get_template_directory() . '/includes/class/walker.php';
require_once __DIR__ . '/vendor/autoload.php';


// Init the Theme
BLOGINA_Bootstrap::instance();


add_filter('use_block_editor_for_post', '__return_false', 10);

add_filter('use_widgets_block_editor', '__return_false');


function convert_date_to_jalali($date_string) {
    if ($timestamp = strtotime($date_string)) {
        // Use the Jalali date function
        return Morilog\Jalali\Jalalian::fromDateTime($timestamp)->format('Y/m/d');
    }
    return $date_string; // Return original date if conversion fails
}

add_filter('get_comment_date', 'convert_date_to_jalali');

// Optional: For custom date formats (like in custom fields or theme options)
add_filter('option_date_format', function($format) {
    return 'Y/m/d'; // Adjust this as needed
});
add_filter('option_time_format', function($format) {
    return 'H:i'; 
});