<?php
// no direct access
defined('ABSPATH') || die();

if(!class_exists('BLOGINAC')):

/**
 * Blogina Class.
 *
 * @version	1.0.0
 */
final class BLOGINAC
{
    /**
     * Version.
     *
     * @var string
     */
    public $version = '1.0.0';

     /**
     * Version.
     *
     * @var string
     */
    public $text_domain = 'blogina-core';

    /**
     * The single instance of the class.
     *
     * @var BLOGINAC
     * @since 1.0.0
     */
    protected static $instance = null;

    /**
     * Main Instance.
     *
     * Ensures only one instance of plugin is loaded or can be loaded.
     *
     * @since 1.0.0
     * @static
     * @see bloginac()
     * @return BLOGINAC - Main instance.
     */
    public static function instance()
    {
        // Get an instance of Class
        if(is_null(self::$instance)) self::$instance = new self();

        // Return the instance
        return self::$instance;
    }

    /**
     * Plugin Constructor.
     */
    protected function __construct()
    {
        // Define Constants
        $this->define_constants();

        // Auto Loader
        spl_autoload_register([$this, 'autoload']);
        spl_autoload_register([$this, 'widget_autoload']);

        // Initialize the Plugin
        $this->init();

        // Include Helper Functions
        $this->helpers();

        // Blogina Core Loaded
        do_action('bloginac_loaded');
    }

    /**
     * Define Plugin Constants.
     */
    private function define_constants()
    {
        if(!defined('BLOGINAC_TEXT_DOMAIN')) define('BLOGINAC_TEXT_DOMAIN',$this->text_domain);

        // Absolute Path
        if(!defined('BLOGINAC_ABSPATH')) define('BLOGINAC_ABSPATH', dirname(__FILE__));

        // Plugin Base Name
        if(!defined('BLOGINAC_BASENAME')) define('BLOGINAC_BASENAME', plugin_basename(BLOGINAC_ABSPATH.'/blogina-core.php'));

        // Directory Name
        if(!defined('BLOGINAC_DIRNAME')) define('BLOGINAC_DIRNAME', basename(BLOGINAC_ABSPATH));

        // Version
        if(!defined('BLOGINAC_VERSION')) define('BLOGINAC_VERSION', $this->version);
    }

    /**
     * Initialize the Plugin
     */
    private function init()
    {
        // Internationalization
        $i18n = new BLOGINAC_i18n();
        $i18n->init();

        // Actions / Filters
        $Hooks = new BLOGINAC_Hooks();
        $Hooks->init();

        // blogina Post Types
        $post_types = new BLOGINAC_PTypes();
        $post_types->init();

        // blogina Taxonomies
        $taxonomies = new BLOGINAC_Taxonomies();
        $taxonomies->init();
    }


    /**
     * Include Helper Functions
     */
    public function helpers()
    {
        // Template Functions
        require_once 'app/includes/helpers/templates.php';

        // Util Functions
        require_once 'app/includes/helpers/util.php';
    }

    /**
     * Automatically load plugin classes whenever needed.
     * @param string $class_name
     * @return void
     */
    private function autoload(string $class_name)
    {
        $class_ex = explode('_', strtolower($class_name));

        // It's not a plugin class
        if ($class_ex[0] != 'bloginac') return;

        // Drop 'bloginac'
        $class_path = array_slice($class_ex, 1);

        // Create Class File Path
        $file_path = ucfirst(BLOGINAC_ABSPATH . '/app/includes/class/' . implode('/', $class_path) . '.php');

        // We found the class!
        if (file_exists($file_path)) require_once $file_path;
    }

    /**
     * Automatically load widget classes whenever needed.
     * @param string $class_name
     * @return void
     */

     private function widget_autoload(string $class_name)
     {
         $class_name_lower = strtolower($class_name);
         
         $prefixes = [
             'bloginac_widgets_' => 'widgets',
             'bloginac_elementor_' => 'elementor',
         ];
     
         $base_path = BLOGINAC_ABSPATH . '/app/includes/';
         
         foreach ($prefixes as $prefix => $folder) {
             if (strpos($class_name_lower, $prefix) === 0) {
                 $class_path = str_replace([$prefix, '_'], ['widget-', '-'], $class_name_lower);
                 $file_path = $base_path . strtolower($folder . '/' . $class_path . '.php');
     
                 if (file_exists($file_path)) require_once $file_path;
                 
                 break; 
             }
         }
     }     
}

endif;