<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Slide')):

    /**
     * Elementor Swiper Widget.
     *
     * @class BLOGINAC_Elementor_Slide
     * @version 1.0.0
     */
    class BLOGINAC_Elementor_Slide extends BLOGINAC_Elementor_Base
    {
        public $slides;
        public $loop;
        public $autoplay;
        public $autoplay_delay;
        public $style;

        public function get_name()
        {
            return 'bloginac-slide';
        }

        public function get_title()
        {
            return __('Blogina Slides', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fab fa-images';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Content', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // Slider Style Selection
            $this->add_control(
                'slider_style',
                [
                    'label' => __('Slider Style', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        'big-slider' => __('Big Slider', BLOGINAC_TEXT_DOMAIN),
                        'cards' => __('Cards', BLOGINAC_TEXT_DOMAIN),
                        'autoplay-progress' => __('AutoPlay Progress', BLOGINAC_TEXT_DOMAIN),
                        'creative' => __('Creative', BLOGINAC_TEXT_DOMAIN),
                        'cube' => __('Cube', BLOGINAC_TEXT_DOMAIN),
                        'coverflow' => __('CoverFlow', BLOGINAC_TEXT_DOMAIN),
                        'creative-2' => __('Creative Style Two', BLOGINAC_TEXT_DOMAIN),
                        'creative-3' => __('Creative Style Three', BLOGINAC_TEXT_DOMAIN),
                        'creative-4' => __('Creative Style Four', BLOGINAC_TEXT_DOMAIN),
                        'creative-5' => __('Creative Style Five', BLOGINAC_TEXT_DOMAIN),
                        'creative-6' => __('Creative Style Six', BLOGINAC_TEXT_DOMAIN),
                    ],
                    'default' => 'cards',
                ]
            );

            // Slides Control
            $this->add_control(
                'slides',
                [
                    'label' => __('Slides', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => [
                        [
                            'name' => 'card_title',
                            'label' => __('Card Title', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => __('Card Title', BLOGINAC_TEXT_DOMAIN),
                        ],
                        [
                            'name' => 'background_color',
                            'label' => __('Background Color', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '#ccc',
                        ],
                        [
                            'name' => 'background_image',
                            'label' => __('Background Image', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'default' => [
                                'url' => \Elementor\Utils::get_placeholder_image_src(),
                            ],
                        ],
                        // Description field (Only for Big Slider)
                        [
                            'name' => 'card_description',
                            'label' => __('Card Description', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'default' => __('Enter description here...', BLOGINAC_TEXT_DOMAIN),
                        ],
                        // Button Text (Only for Big Slider)
                        [
                            'name' => 'button_text',
                            'label' => __('Button Text', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => __('Learn More', BLOGINAC_TEXT_DOMAIN),
                        ],
                        // Button URL (Only for Big Slider)
                        [
                            'name' => 'button_url',
                            'label' => __('Button URL', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::URL,
                            'placeholder' => __('https://your-link.com', BLOGINAC_TEXT_DOMAIN),
                        ],
                    ],
                    'default' => [
                        [
                            'card_title' => __('Slide 1', BLOGINAC_TEXT_DOMAIN),
                            'background_color' => '#ce1111',
                        ],
                        [
                            'card_title' => __('Slide 2', BLOGINAC_TEXT_DOMAIN),
                            'background_color' => '#008cff',
                        ],
                    ],
                    'title_field' => '{{{ card_title }}}',
                ]
            );

            // Enable Loop
            $this->add_control(
                'enable_loop',
                [
                    'label' => __('Enable Loop', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                    'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                    'default' => 'no',
                ]
            );

            // Enable AutoPlay
            $this->add_control(
                'enable_autoplay',
                [
                    'label' => __('Enable AutoPlay', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                    'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                    'default' => 'yes',
                ]
            );

            // AutoPlay Delay (Only if AutoPlay is Enabled)
            $this->add_control(
                'autoplay_delay',
                [
                    'label' => __('AutoPlay Delay (ms)', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::NUMBER,
                    'min' => 1000,
                    'max' => 10000,
                    'step' => 100,
                    'default' => 4500,
                    'condition' => [
                        'enable_autoplay' => 'yes',
                    ],
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $this->style = $settings['slider_style'] ?? 'cards';
            $this->slides = $settings['slides'];
            $this->loop = $settings['enable_loop'] === 'yes';
            $this->autoplay = $settings['enable_autoplay'] === 'yes';
            $this->autoplay_delay = $settings['autoplay_delay'];

            $this->include_elementor_html_file('slider/cards.php');
        }
    }

endif;
