<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_ScrollToTop')) :

    /**
     * Elementor Scroll-to-Top Widget.
     *
     * @class BLOGINAC_Elementor_ScrollToTop
     * @version 1.0.0
     */
    class BLOGINAC_Elementor_ScrollToTop extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-scroll-to-top';
        }

        public function get_title()
        {
            return __('Scroll to Top', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-arrow-circle-up';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Scroll-to-Top Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // Button Text
            $this->add_control(
                'button_text',
                [
                    'label' => __('Button Text', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => 'Top',
                    'placeholder' => __('Enter text', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            // Scroll Icon
            $this->add_control(
                'icon',
                [
                    'label' => __('Icon', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-arrow-up',
                        'library' => 'fa-solid',
                    ],
                ]
            );

            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            // Button Size
            $this->add_control(
                'button_size',
                [
                    'label' => __('Button Size', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => ['px', 'em', '%'],
                    'range' => [
                        'px' => ['min' => 20, 'max' => 150],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-scroll-top' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            // Background Color
            $this->add_control(
                'bg_color',
                [
                    'label' => __('Background Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#000',
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-scroll-top' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            // Icon/Text Color
            $this->add_control(
                'text_color',
                [
                    'label' => __('Text/Icon Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-scroll-top' => 'color: {{VALUE}};',
                    ],
                ]
            );

            // Border Radius
            $this->add_control(
                'border_radius',
                [
                    'label' => __('Border Radius', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => ['px', '%'],
                    'range' => [
                        'px' => ['min' => 0, 'max' => 50],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 25,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-scroll-top' => 'border-radius: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $button_text = $settings['button_text'];
            $icon = $settings['icon'];

            // Unique ID for multiple instances
            $uniq_id = uniqid('bloginac-scroll-top-');

            ?>
            <div id="<?php echo esc_attr($uniq_id); ?>" class="bloginac-scroll-top" style="display: none;">
                <?php if (!empty($icon['value'])) : ?>
                    <i class="<?php echo esc_attr($icon['value']); ?>"></i>
                <?php else : ?>
                    <?php echo esc_html($button_text); ?>
                <?php endif; ?>
            </div>

            <script>
                (function ($) {
                    $(document).ready(function () {
                        const scrollTopBtn = $('#<?php echo esc_attr($uniq_id); ?>');

                        $(window).scroll(function () {
                            if ($(this).scrollTop() > 300) {
                                scrollTopBtn.fadeIn();
                            } else {
                                scrollTopBtn.fadeOut();
                            }
                        });

                        scrollTopBtn.on('click', function () {
                            $('html, body').animate({ scrollTop: 0 }, 800);
                        });
                    });
                })(jQuery);
            </script>
            <?php
        }
    }

endif;
