<?php
// no direct access
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

defined('ABSPATH') || die();

/**
 * Elementor Excerpt Widget.
 *
 * @class BLOGINAC_Elementor_Excerpt
 * @version 1.0.0
 */
class BLOGINAC_Elementor_Excerpt extends BLOGINAC_Elementor_Single
{
    public function get_name()
    {
        return 'bloginac-excerpt';
    }

    public function get_title()
    {
        return __('Blogina Excerpt', BLOGINAC_TEXT_DOMAIN);
    }

    public function get_icon()
    {
        return 'fas fa-align-center';
    }

    protected function register_controls()
    {
        // Content section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        // Excerpt length control
        $this->add_control(
            'excerpt_length',
            [
                'label' => __('Length', BLOGINAC_TEXT_DOMAIN),
                'type' => Controls_Manager::NUMBER,
                'default' => 40,
                'min' => 1,
                'max' => 200,
                'step' => 1,
            ]
        );

        // Excerpt color control
        $this->add_control(
            'excerpt_color',
            [
                'label' => __('Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blgelm-single-excerpt' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'excerpt_typography',
                'label' => __('Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blgelm-single-excerpt',
            ]
        );

        // Text alignment control
        $this->add_control(
            'excerpt_alignment',
            [
                'label' => __('Text Alignment', BLOGINAC_TEXT_DOMAIN),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => __('Justify', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .blgelm-single-excerpt' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function course(BLOGINAC_Entity_Course $course): string
    {
        // Get the settings for the widget
        $settings = $this->get_settings_for_display();

        $excerpt_length = $settings['excerpt_length'] ?? 40;

        $excerpt = $course->get_excerpt($course->id(), $excerpt_length);

        return '<div class="blgelm-single-excerpt">' . $excerpt . '</div>';
    }
}
