<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_CTA')):

    /**
     * Elementor Call to Action Widget.
     *
     * @class BLOGINAC_Elementor_CTA
     * @version 1.2.0
     */
    class BLOGINAC_Elementor_CTA extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-cta';
        }

        public function get_title()
        {
            return __('Blogina Call to Action', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-mouse';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Content', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => __('Title', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Get Started Today!', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            $this->add_control(
                'description',
                [
                    'label' => __('Description', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'default' => __('Take the first step toward your goals with our amazing solutions.', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            $this->add_control(
                'button_text',
                [
                    'label' => __('Button Text', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Get Started', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            $this->add_control(
                'button_link',
                [
                    'label' => __('Button Link', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::URL,
                    'placeholder' => __('https://example.com', BLOGINAC_TEXT_DOMAIN),
                    'default' => [
                        'url' => '#',
                    ],
                ]
            );

            // Text Alignment Control
            $this->add_control(
                'text_align',
                [
                    'label' => __('Text Alignment', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __('Left', BLOGINAC_TEXT_DOMAIN),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => __('Center', BLOGINAC_TEXT_DOMAIN),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => __('Right', BLOGINAC_TEXT_DOMAIN),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'default' => 'center',
                ]
            );

            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            // Background Image Section
            $this->add_control(
                'background_image',
                [
                    'label' => __('Background Image', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::MEDIA,
                ]
            );

            // Background Position
            $this->add_control(
                'background_position',
                [
                    'label' => __('Background Position', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'center center',
                    'options' => [
                        'center center' => __('Center Center', BLOGINAC_TEXT_DOMAIN),
                        'top center' => __('Top Center', BLOGINAC_TEXT_DOMAIN),
                        'bottom center' => __('Bottom Center', BLOGINAC_TEXT_DOMAIN),
                        'top left' => __('Top Left', BLOGINAC_TEXT_DOMAIN),
                        'top right' => __('Top Right', BLOGINAC_TEXT_DOMAIN),
                        'bottom left' => __('Bottom Left', BLOGINAC_TEXT_DOMAIN),
                        'bottom right' => __('Bottom Right', BLOGINAC_TEXT_DOMAIN),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .blg-cta-wrapper' => 'background-position: {{VALUE}};',
                    ],
                ]
            );

            // Background Size
            $this->add_control(
                'background_size',
                [
                    'label' => __('Background Size', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'cover',
                    'options' => [
                        'cover' => __('Cover', BLOGINAC_TEXT_DOMAIN),
                        'contain' => __('Contain', BLOGINAC_TEXT_DOMAIN),
                        'auto' => __('Auto', BLOGINAC_TEXT_DOMAIN),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .blg-cta-wrapper' => 'background-size: {{VALUE}};',
                    ],
                ]
            );

            // Background Repeat
            $this->add_control(
                'background_repeat',
                [
                    'label' => __('Background Repeat', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'no-repeat',
                    'options' => [
                        'no-repeat' => __('No Repeat', BLOGINAC_TEXT_DOMAIN),
                        'repeat' => __('Repeat', BLOGINAC_TEXT_DOMAIN),
                        'repeat-x' => __('Repeat Horizontally', BLOGINAC_TEXT_DOMAIN),
                        'repeat-y' => __('Repeat Vertically', BLOGINAC_TEXT_DOMAIN),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .blg-cta-wrapper' => 'background-repeat: {{VALUE}};',
                    ],
                ]
            );

            // Background Attachment (Fixed/Scroll)
            $this->add_control(
                'background_attachment',
                [
                    'label' => __('Background Attachment', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'scroll',
                    'options' => [
                        'scroll' => __('Scroll', BLOGINAC_TEXT_DOMAIN),
                        'fixed' => __('Fixed', BLOGINAC_TEXT_DOMAIN),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .blg-cta-wrapper' => 'background-attachment: {{VALUE}};',
                    ],
                ]
            );

            // Background Overlay
            $this->add_control(
                'overlay_color',
                [
                    'label' => __('Overlay Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .blg-cta-wrapper' => 'background-color: rgba({{VALUE}}, 0.5);',
                    ],
                ]
            );

            $this->end_controls_section();

            $this->start_controls_section(
                'button_section',
                [
                    'label' => __('Button', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            $this->add_control(
                'button_bg_color',
                [
                    'label' => __('Button Background Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => 'var(--blg-color-secondary200)',
                    'selectors' => [
                        '{{WRAPPER}} .blg-cta-wrapper .blg-btn' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'button_hover_bg',
                [
                    'label' => __('Button Hover Background Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => 'var(--blg-color-secondary100)',
                    'selectors' => [
                        '{{WRAPPER}} .blg-cta-wrapper .blg-btn:hover' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'button_text_color',
                [
                    'label' => __('Button Text Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .blg-cta-wrapper .blg-btn' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'button_hover_text',
                [
                    'label' => __('Button Hover Text Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .blg-cta-wrapper .blg-btn:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $title = $settings['title'] ?? '';
            $description = $settings['description'] ?? '';
            $button_text = $settings['button_text'] ?? '';
            $button_link = $settings['button_link']['url'] ?? '#';

            ?>
            <div class="blg-cta-wrapper py-10 px-6 text-center rounded-lg shadow-lg">
                <h2 class="text-2xl font-bold mb-4"><?php echo esc_html($title); ?></h2>
                <p class="mb-6"><?php echo esc_html($description); ?></p>
                <a href="<?php echo esc_url($button_link); ?>" class="blg-btn inline-block px-6 py-3 rounded-lg font-semibold transition">
                    <?php echo esc_html($button_text); ?>
                </a>
            </div>
            <?php
        }
    }

endif;
