<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Button')):

/**
 * Elementor Button Widget.
 *
 * @class BLOGINAC_Elementor_Button
 * @version 1.0.0
 */
class BLOGINAC_Elementor_Button extends BLOGINAC_Elementor_Base
{

    public $button_text;
    public $button_icon;
    public $show_icon;
    public $button_url;
    public function get_name()
    {
        return 'bloginac-button';
    }

    public function get_title()
    {
        return __('Blogina Button', BLOGINAC_TEXT_DOMAIN);
    }

    public function get_icon()
    {
        return 'fas fa-square fa-spin';
    }

    public function get_categories()
    {
        return ['blogina'];
    }

    protected function register_controls()
    {
        // Content Tab
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Button', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __('Button Text', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('view all', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'show_icon',
            [
                'label' => __('Show Icon', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label' => __('Icon', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-info-circle',
                    'library' => 'solid',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('Button URL', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://example.com', BLOGINAC_TEXT_DOMAIN),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Button Style', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Tabs: Default and Hover
        $this->start_controls_tabs('style_tabs');

        // Normal State
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => __('Normal', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => __('Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-btn',
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __('Button Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .blg-btn' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'button_bg',
            [
                'label' => __('Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'var(--blg-color-secondary200)',
                'selectors' => [
                    '{{WRAPPER}} .blg-btn' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'label' => __('Border', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-btn',
            ]
        );

        $this->add_control(
            'button_radius',
            [
                'label' => __('Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .blg-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label' => __('Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => 6,
                    'right' => 6,
                    'bottom' => 6,
                    'left' => 6,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .blg-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_gap',
            [
                'label' => __('Icon Gap', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .blg-btn' => 'gap: {{SIZE}}{{UNIT}} !important;',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->end_controls_tab();

        // Hover State
        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => __('Hover', BLOGINAC_TEXT_DOMAIN),
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'hover_button_typography',
                'label' => __('Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-btn:hover',
            ]
        );

        $this->add_control(
            'hover_button_bg',
            [
                'label' => __('Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'var(--blg-color-secondary100)',
                'selectors' => [
                    '{{WRAPPER}} .blg-btn:hover' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'hover_button_color',
            [
                'label' => __('Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .blg-btn:hover' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'hover_button_border',
                'label' => __('Border', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-btn:hover',
            ]
        );

        $this->add_control(
            'hover_button_radius',
            [
                'label' => __('Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .blg-btn:hover' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'icon_section',
            [
                'label' => __('Icon Style', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Tabs: Default and Hover
        $this->start_controls_tabs('icon_style_tabs');

        // Normal State
        $this->start_controls_tab(
            'icon_style_normal_tab',
            [
                'label' => __('Normal', BLOGINAC_TEXT_DOMAIN),
            ]
        );
        
        $this->add_control(
            'icon_box_padding',
            [
                'label' => __('Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .blg-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label' => __('Icon Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .blg-icon' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blg-icon' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_tab();

        // Hover State
        $this->start_controls_tab(
            'icon_style_hover_tab',
            [
                'label' => __('Hover', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'hover_icon_bg_color',
            [
                'label' => __('Hover Icon Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .blg-btn:hover .blg-icon' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'hover_icon_color',
            [
                'label' => __('Hover Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .blg-btn:hover .blg-icon' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $this->button_text = $settings['button_text'] ?? esc_html__('view all', BLOGINAC_TEXT_DOMAIN);
        $this->button_icon = $settings['button_icon'];
        $this->show_icon = $settings['show_icon'] === 'yes';
        $this->button_url = $settings['button_url']['url'] ?? '';

        ?>
        <div class="w-full blgelm-btn-wrapper">
            <a href="<?php echo esc_url($this->button_url); ?>">
                <button class="blg-btn font-semibold flex items-center">
                    <?php echo esc_html($this->button_text); ?>
                    <?php if ($this->show_icon): ?>
                        <div class="blg-icon rounded-[6px] px-[6px] py-2">
                            <?php
                            \Elementor\Icons_Manager::render_icon($this->button_icon, [
                                'aria-hidden' => 'true',
                                'class' => 'lg:w-5 lg:h-5 w-4 h-4',
                            ]);
                            ?>
                        </div>
                    <?php endif; ?>
                </button>
            </a>
        </div>
        <?php
    }
}

endif;
