<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Breadcrumb')):

/**
 * Elementor Breadcrumb Widget.
 *
 * @class BLOGINAC_Elementor_Breadcrumb
 * @version 1.0.0
 */
class BLOGINAC_Elementor_Breadcrumb extends BLOGINAC_Elementor_Base
{
    public function get_name()
    {
        return 'bloginac-breadcrumb';
    }

    public function get_title()
    {
        return __('Breadcrumb', BLOGINAC_TEXT_DOMAIN);
    }

    public function get_icon()
    {
        return 'fas fa-map-signs';
    }

    public function get_categories()
    {
        return ['blogina'];
    }

    protected function register_controls()
    {
        // Breadcrumb Section
        $this->start_controls_section(
            'breadcrumb_section',
            [
                'label' => __('Breadcrumb Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'separator',
            [
                'label' => __('Separator', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M10 4L6 8L10 12" stroke="#FEC752" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>',
                'placeholder' => __('Enter SVG separator', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'home_text',
            [
                'label' => __('Home Text', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Home Page', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'show_current',
            [
                'label' => __('Show Current Page', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // End Section
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
    
        $separator = !empty($settings['separator']) ? $settings['separator'] : '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
            <path d="M10 4L6 8L10 12" stroke="#FEC752" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>';
        $home_text = !empty($settings['home_text']) ? esc_html($settings['home_text']) : __('Home', BLOGINAC_TEXT_DOMAIN);
        $show_current = $settings['show_current'] === 'yes';
    
        // Generate Breadcrumb
        $breadcrumb = '<nav class="breadcrumb flex items-center gap-x-1 py-4">';
        $breadcrumb .= '<a class="text-[#818181] font-normal text-[15px]" href="' . esc_url(home_url()) . '">' . esc_html($home_text) . '</a>';
    
        if (is_single()) {
            $breadcrumb .= ' ' . $separator . ' ';
            $breadcrumb .= '<a class="text-[15px] text-[#464646]" href="' . esc_url(get_permalink(get_option('page_for_posts'))) . '">' . esc_html(get_the_title(get_option('page_for_posts'))) . '</a>';
            if ($show_current) {
                $breadcrumb .= ' ' . $separator . ' ';
                $breadcrumb .= '<span class="text-[15px] text-[#464646]">' . esc_html(get_the_title()) . '</span>';
            }
        } elseif (is_page()) {
            $breadcrumb .= ' ' . $separator . ' ';
            if ($show_current) {
                $breadcrumb .= '<span class="text-[15px] text-[#464646]">' . esc_html(get_the_title()) . '</span>';
            }
        } elseif (is_category()) {
            $breadcrumb .= ' ' . $separator . ' ';
            $breadcrumb .= '<span class="text-[15px] text-[#464646]">' . esc_html(single_cat_title('', false)) . '</span>';
        } elseif (is_tag()) {
            $breadcrumb .= ' ' . $separator . ' ';
            $breadcrumb .= '<span class="text-[15px] text-[#464646]">' . esc_html(single_tag_title('', false)) . '</span>';
        } elseif (is_archive()) {
            $breadcrumb .= ' ' . $separator . ' ';
            $breadcrumb .= '<span class="text-[15px] text-[#464646]">' . esc_html(get_the_archive_title()) . '</span>';
        }
    
        $breadcrumb .= '</nav>';
    
        echo $breadcrumb;
    }
    
}

endif;
