<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Statistics_Style extends BLOGINAC_Elementor_Statistics
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Start Title Style Section
        $this->start_controls_section(
            'section_statistics_title_styles',
            [
                'label' => __('Title Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ],

        );

        // Title Typography Control
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-stats-num',
            ]
        );

        // Title Color Control
        $this->add_control(
            'statistics_title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-stats-num' => 'color: {{VALUE}};',
                ],
            ]
        );

        // Title Color Control
        $this->add_control(
            'statistics_icon_color',
            [
                'label' => __('Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-stats-icon svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();

        // Start Title Style Section
        $this->start_controls_section(
            'section_statistics_desc_styles',
            [
                'label' => __('Description Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ],

        );

        // Title Typography Control
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'label' => __('Description Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-stats-desc',
            ]
        );

        // Title Color Control
        $this->add_control(
            'statistics_desc_color',
            [
                'label' => __('Description Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-stats-desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
