<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Statistics_Settings extends BLOGINAC_Elementor_Statistics
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
    // Start the content section
    $this->start_controls_section(
        'content_section',
        [
            'label' => __('Content', BLOGINAC_TEXT_DOMAIN),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
    );

    // Repeater for Statistics
    $repeater = new \Elementor\Repeater();

    // Icon Control
    $repeater->add_control(
        'icon',
        [
            'label' => __('Icon', BLOGINAC_TEXT_DOMAIN),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fas fa-info-circle',
                'library' => 'solid',
            ],
        ]
    );

    // Number Control
    $repeater->add_control(
        'number',
        [
            'label' => __('Number', BLOGINAC_TEXT_DOMAIN),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('0', BLOGINAC_TEXT_DOMAIN),
        ]
    );

    // Description Control
    $repeater->add_control(
        'description',
        [
            'label' => __('Description', BLOGINAC_TEXT_DOMAIN),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Description', BLOGINAC_TEXT_DOMAIN),
        ]
    );

    // Add Repeater Control to Main Control
    $this->add_control(
        'statistics_list',
        [
            'label' => __('Statistics List', BLOGINAC_TEXT_DOMAIN),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'icon' => [
                        'value' => 'fas fa-briefcase',
                        'library' => 'solid',
                    ],
                    'number' => __('+15', BLOGINAC_TEXT_DOMAIN),
                    'description' => __('Year Experience', BLOGINAC_TEXT_DOMAIN),
                ],
                [
                    'icon' => [
                        'value' => 'fas fa-briefcase',
                        'library' => 'solid',
                    ],
                    'number' => __('+6000', BLOGINAC_TEXT_DOMAIN),
                    'description' => __('User', BLOGINAC_TEXT_DOMAIN),
                ],
                [
                    'icon' => [
                        'value' => 'fas fa-briefcase',
                        'library' => 'solid',
                    ],
                    'number' => __('+400', BLOGINAC_TEXT_DOMAIN),
                    'description' => __('Blog', BLOGINAC_TEXT_DOMAIN),
                ],
                [
                    'icon' => [
                        'value' => 'fas fa-briefcase',
                        'library' => 'solid',
                    ],
                    'number' => __('+25', BLOGINAC_TEXT_DOMAIN),
                    'description' => __('Course', BLOGINAC_TEXT_DOMAIN),
                ],
            ],
            'title_field' => '{{{ number }}}',
        ]
    );

    $this->end_controls_section();
    }

}
