<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_SpeacialOffers_Settings extends BLOGINAC_Elementor_SpeacialOffers
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Get all terms from the custom taxonomy
        $categories = get_terms([
            'taxonomy'   => BLOGINAC_Base::TAX_COURSE_CATEGORY,
            'hide_empty' => true,
        ]);

        // Prepare options array
        $categories_options = [
            '' => __('All Categories', BLOGINAC_TEXT_DOMAIN)
        ];

        if (!is_wp_error($categories)) {
            foreach ($categories as $category) {
                $categories_options[$category->term_id] = $category->name;
            }
        }

        // Define ordering options
        $order_options = [
            'date' => __('Date', BLOGINAC_TEXT_DOMAIN),
            'title' => __('Title', BLOGINAC_TEXT_DOMAIN),
            'rand' => __('Random', BLOGINAC_TEXT_DOMAIN),
        ];

        // Posts Section
        $this->start_controls_section(
            'course_section',
            [
                'label' => __('Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'product_type',
            [
                'label'   => __('Products', BLOGINAC_TEXT_DOMAIN),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'discounted'     => __('Discounted Products', BLOGINAC_TEXT_DOMAIN),
                    'special_offers' => __('Special Offers', BLOGINAC_TEXT_DOMAIN),
                ],
                'default' => 'discounted',
            ]
        );

        // Number of Posts Control
        $this->add_control(
            'posts_count',
            [
                'label' => __('Number of Courses', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );

        $this->add_control(
            'post_category',
            [
                'label' => __('Post Category', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $categories_options,
                'default' => '',
                'description' => __('Select category for the main course section.', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'post_order',
            [
                'label' => __('Post Order By', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $order_options,
                'default' => 'rand',
                'description' => __('Select order by for the main course section.', BLOGINAC_TEXT_DOMAIN),
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'filter_section',
            [
                'label' => __('Product Filter', BLOGINAC_TEXT_DOMAIN),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'product_filter',
            [
                'label'   => __('Select Product Filter', BLOGINAC_TEXT_DOMAIN),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'all'            => __('All Products', BLOGINAC_TEXT_DOMAIN),
                    'newest'         => __('Newest Products', BLOGINAC_TEXT_DOMAIN),
                    'oldest'         => __('Oldest Products', BLOGINAC_TEXT_DOMAIN),
                    'highest_price'  => __('Highest Price', BLOGINAC_TEXT_DOMAIN),
                    'lowest_price'   => __('Lowest Price', BLOGINAC_TEXT_DOMAIN),
                    'most_stars'     => __('Most Stars', BLOGINAC_TEXT_DOMAIN),
                    'least_stars'    => __('Least Stars', BLOGINAC_TEXT_DOMAIN),
                ],
                'default' => 'all',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __('Slider', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'enable_sliders',
            [
                'label' => __('Enable slider', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'enable_autoplay',
            [
                'label' => __('Autoplay', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => __('AutoPlay Delay (ms)', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'max' => 10000,
                'step' => 100,
                'default' => 2000,
                'condition' => [
                    'enable_autoplay' => 'yes',
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'enable_loop',
            [
                'label' => __('Loop', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => __('Show Pagination', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_navigation',
            [
                'label' => __('Show Navigations', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'title_section',
            [
                'label' => __('Title and Buttons', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_title',
            [
                'label' => __('Show Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'main_title',
            [
                'label' => __('Main Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Special Offers', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'video_section',
            [
                'label' => __('Video', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'enable_video',
            [
                'label' => __('Enable Video', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'video_autoplay',
            [
                'label' => __('Autoplay', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_video' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'show_controls',
            [
                'label' => __('Show Controls', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_video' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'columns_section',
            [
                'label' => __('Columns', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'columns_desktop',
            [
                'label' => __('Desktop Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
                'min' => 1,
                'max' => 6,
                'step' => 1,
            ]
        );

        $this->add_control(
            'columns_lg',
            [
                'label' => __('LG Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 1,
                'max' => 4,
                'step' => 1,
                'description' => __('Select the number of columns for large screen (1024px above)', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'columns_tablet',
            [
                'label' => __('Tablet Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 2,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'description' => __('Select the number of columns for tablet (768px to 1024px) ', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
