<?php
// Prevent direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Controls_Title')):

/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Course_Title extends BLOGINAC_Elementor_Course {

    /**
     * Add title style controls
     */
    public function register_controls() {
        // Start Title Style Section
        $this->start_controls_section(
            'section_title_styles',
            [
                'label' => __('Title Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'style_option' => ['style2', 'style3'],
                ],
            ],

        );

        // Title Typography Control
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .course-post-title h3',
                'condition' => [
                    'style_option' => ['style2', 'style3'],
                ],
            ]
        );

        // Title Color Control
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-title h3' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'style_option' => ['style2', 'style3'],
                ],
            ]
        );

        $this->add_control(
            'title_underline_color',
            [
                'label' => __('Title Underline Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-title .blg-title-underline' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'style_option' => ['style2', 'style3'],
                ],
            ]
        );

        // Button Text Color Control
        $this->add_control(
            'show_more_button_color',
            [
                'label' => __('Button Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-title .blg-btn-secondary' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'style_option' => ['style2', 'style3'],
                ],
            ]
        );

        // Button Background Color Control
        $this->add_control(
            'show_more_button_bg',
            [
                'label' => __('Button Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-title .blg-btn-secondary' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'style_option' => ['style2', 'style3'],
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}

endif;
