<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Course_Cards extends BLOGINAC_Elementor_Course
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_course_card_styles',
            [
                'label' => __('Card Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE, // Add this section to the Style tab
            ]
        );

        // Card Background Color Control
        $this->add_control(
            'card_bg_color',
            [
                'label' => __('Card Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-card h4' => 'color: {{VALUE}};',
                ],
            ]
        );
        

        $this->add_control(
            'card_title_icon_color',
            [
                'label' => __('Title Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-card svg circle' => 'fill: {{VALUE}};',
                ],
            ]
        );

        // Card Padding Control
        $this->add_responsive_control(
            'card_padding',
            [
                'label' => __('Card Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .course-post-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Card Border Radius Control
        $this->add_control(
            'card_radius',
            [
                'label' => __('Card Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 16,
                    'right' => 16,
                    'bottom' => 16,
                    'left' => 16,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .course-post-card' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_shadow',
                'label' => __('Card Shadow', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .course-post-card',
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
