<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Blog_Cards extends BLOGINAC_Elementor_Posts
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_blog_card_styles',
            [
                'label' => __('Card Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE, // Add this section to the Style tab
            ]
        );

        $this->add_control(
            'show_author',
            [
                'label' => __('Show Author', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'default' => 'yes',
                'condition' => [
                    'style_option' => 'style1',
                ],
            ]
        );

        $this->add_control(
            'show_time',
            [
                'label' => __('Show Reading Time', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_tag',
            [
                'label' => __('Show Tag', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'default' => 'yes',
            ]
        );

        // Card Background Color Control
        $this->add_control(
            'card_bg_color',
            [
                'label' => __('Card Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-post-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-post-card h4' => 'color: {{VALUE}};',
                ],
            ]
        );
        

        $this->add_control(
            'card_title_icon_color',
            [
                'label' => __('Title Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-post-card svg circle' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_p_color',
            [
                'label' => __('Description Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} p.blog-excerpt' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'style_option' => 'style1',
                ],
            ]
        );
        
        // Card Padding Control
        $this->add_responsive_control(
            'card_padding',
            [
                'label' => __('Card Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-post-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Card Border Radius Control
        $this->add_control(
            'card_radius',
            [
                'label' => __('Card Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-post-card' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_shadow',
                'label' => __('Card Shadow', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blog-post-card',
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
