<?php

/** @var BLOGINAC_Woocommerce $this */
$endpoints = wc_get_account_menu_items();

$template_mapping = [
    'dashboard' => 'dashboard.php',
    'orders' => 'orders.php',
    'downloads' => 'downloads.php',
    'edit-address' => 'form-edit-address.php',
    'edit-account' => 'form-edit-account.php',
    'customer-logout' => null,
];

if (isset($_POST['endpoint'])) {
    $endpoint = sanitize_text_field($_POST['endpoint']);

    if (array_key_exists($endpoint, $endpoints)) {
        if ($endpoint === 'customer-logout') {
            wp_logout();
        
            $redirect_url = wc_get_page_permalink('myaccount');
        
            $this->response([
                'success' => 1,
                'message' => esc_html__('You have been logged out successfully.', BLOGINAC_TEXT_DOMAIN),
                'redirect_url' => $redirect_url,
            ]);
        
            return;
        }

        $template_file = $template_mapping[$endpoint] ?? null;

        if ($template_file) {
            $template_path = get_template_directory() . "/woocommerce/myaccount/{$template_file}";

            if (file_exists($template_path)) {
                ob_start();
                include $template_path;
                $content = ob_get_clean();
                $this->response(['success' => 1, 'message' => esc_html__('Content loaded successfully.', BLOGINAC_TEXT_DOMAIN), 'content' => $content]);
            } else {
                $this->response(['success' => 0, 'message' => esc_html__('Template not found for the given endpoint.', BLOGINAC_TEXT_DOMAIN)]);
            }
        }
    }
}

wp_die();