<div id="<?php echo esc_attr($list_id); ?>" class="course-sidebar-widget-section hidden my-4">
    <div class="lsd-form-row">
        <div class="lsd-col-2">
            <?php echo BLOGINAC_Form::label([
                'title' => $label,
                'for' => $list_id,
            ]); ?>
        </div>
        <div class="lsd-col-6">
            <?php if (!empty($terms) && !is_wp_error($terms)) : ?>
                <div class="flex flex-wrap flex-col gap-y-3">
                    <?php foreach ($terms as $term) : ?>
                        <div class="flex items-center gap-x-2 justify-between px-2 py-1">
                            <label for="term_<?php echo esc_attr($term->term_id); ?>" class="text-gray-700 text-sm">
                                <?php echo esc_html($term->name); ?>
                            </label>
                            <input type="checkbox" id="term_<?php echo esc_attr($term->term_id); ?>" class="<?php echo esc_attr($filter_class); ?> form-checkbox w-1 h-1 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500 bg-[var(--blg-gray)]" data-id="<?php echo esc_attr($term->term_id); ?>" />

                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else : ?>
                <p class="text-gray-500 text-sm"><?php esc_html_e('No items found.', BLOGINAC_TEXT_DOMAIN); ?></p>
            <?php endif; ?>
        </div>
    </div>
</div>