<?php
// no direct access
defined('ABSPATH') || die();

/** @var WP_Post $post */
global $post;
// Retrieve 'blg' meta key
$blg = get_post_meta($post->ID, 'blg-television', true);
$blg = is_array($blg) ? $blg : []; // Ensure $blg is an array

// Extract individual fields
$television_video = isset($blg['video']) ? $blg['video'] : [];
?>
<div class="blg-metabox">

    <div class="blg-metabox-input">
        <!-- Mentor Select Box -->
        <div class="blg-form-row">
            <?php
            echo BLOGINAC_Form::hidden([
                'name' => 'blg[video-time]',
                'id' => 'blg_video_time',
                'value' => '',
            ]);
            ?>
        </div>
    </div>

    <!-- Video Upload -->
    <div class="blg-form-video">
        <div class="blg-video-button">
            <button type="button" class="blg-button" id="blg_upload_video">
                <?php esc_attr_e('Add Video', BLOGINAC_TEXT_DOMAIN); ?>
                <i class="fas fa-photo-video"></i>
            </button>
        </div>
        <div id="blg_video_preview">
            <?php if (!empty($television_video)): ?>
                <video controls>
                    <source class="plyr" src="<?php echo esc_url(wp_get_attachment_url($television_video)); ?>" type="video/mp4">
                    <?php esc_html_e('Your browser does not support the video tag.', BLOGINAC_TEXT_DOMAIN); ?>
                </video>
                <input type="hidden" name="blg[video]" value="<?php echo esc_attr($television_video); ?>">
                <a href="#" class="blg-remove-video"><i class="fa fa-trash"></i></a>
            <?php endif; ?>
        </div>
    </div>

</div>
