<?php
// no direct access
defined('ABSPATH') || die();

/** @var WP_Post $post */
global $post;

// Retrieve 'blg' meta key
$blg = get_post_meta($post->ID, 'blg-television', true);
$blg = is_array($blg) ? $blg : []; // Ensure $blg is an array

// Extract individual fields
$gallery = isset($blg['gallery']) ? $blg['gallery'] : [];
?>
<div class="blg-metabox">
    <div class="blg-form-gallery">
        <div class="blg-gallery-button">
            <button type="button" class="blg-button" id="blg_upload_gallery">
                <?php esc_attr_e('Add Images', BLOGINAC_TEXT_DOMAIN); ?>
                <i class="fas fa-image"></i>
            </button>
        </div>
        <ul id="blg_gallery_list" class="blg-gallery-images">
            <?php foreach ($gallery as $image_id): ?>
                <li>
                    <?php echo wp_get_attachment_image($image_id, 'thumbnail'); ?>
                    <input type="hidden" name="blg[gallery][]" value="<?php echo esc_attr($image_id); ?>">
                    <a href="#" class="blg-remove-image"><i class="fa fa-trash"></i></a>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>

</div>