<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_Experts $this */

$slides = $this->slides;
?>
<div class="blg-widget-padding-y">
    <div class="grid lg:grid-cols-7 grid-cols-1 items-start justify-center xl:gap-x-24 gap-x-6 py-28 lg:py-2">

        <div class="flex col-span-3 flex-col items-start gap-y-6 justify-center relative">
            <div class="w-full h-full relative lg:right-0 right-10">
                <div class="absolute top-0 right-0 w-[125px] h-[125px] bg-[#F0F5F9] rounded-[var(--blg-radius-3xl)] relative">
                    <div class="absolute bottom-4 right-[-8px] rounded-full flex items-center justify-center bg-gray-300 bg-opacity-50 shadow-inner shadow-gray-400/10 backdrop-blur-[2.0581939220428467px] p-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="21" viewBox="0 0 18 21" fill="none">
                            <path d="M0.113857 10.671L17.2048 0.949208L17.0787 20.6113L0.113857 10.671Z" fill="var(--blg-color-secondary200)" />
                        </svg>
                    </div>
                </div>
                <div class="absolute -top-8  right-[150px] w-[24px] h-[24px] bg-[var(--blg-color-primary500)] rounded-[var(--blg-radius-lg)]"></div>
                <div class="absolute top-14 right-[150px] w-[93px] h-[93px] bg-[var(--blg-color-primary400)] rounded-[var(--blg-radius-3xl)]"></div>
            </div>

            <div class="flex flex-col gap-y-2 lg:pt-12 experts-post-title">
                <h3 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php echo esc_html($this->main_title); ?></h3>
                <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                    <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px] blg-title-underline"></div>
                </div>
            </div>

            <div class="flex flex-col">
                <div class="lg:w-[70%] text-right text-[var(--blg-gray)] experts-post-desc"><?php echo esc_html($this->description); ?></div>
            </div>

            <div class="w-full h-full relative max-lg:hidden">
                <div class="absolute lg:-bottom-10 bottom-[0] left-[70px] rounded-full flex !items-center justify-center bg-gray-300 bg-opacity-50 !shadow-inner !shadow-gray-400/10 !backdrop-blur-[2.0581939220428467px] w-12 h-12">
                    <svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 24 26" fill="none">
                        <path d="M23.9441 0.361879L21.9859 25.8554L0.887038 11.4128L23.9441 0.361879Z" fill="#78818D" />
                    </svg>
                </div>
                <div class="absolute lg:-bottom-20 bottom-[70px] left-[30px] w-[24px] h-[24px] bg-[var(--blg-color-secondary200)] rounded-[var(--blg-radius-lg)]"></div>
                <div class="absolute lg:-bottom-32 bottom-[20px] left-[100px] w-[64px] h-[64px] bg-[var(--blg-color-primary400)] rounded-[6px]"></div>
            </div>
        </div>

        <div class="w-full col-span-4 lg:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] max-md:py-10 px-2 grid grid-cols-4 lg:gap-x-6 gap-x-2">
            <div class="col-span-2 flex flex-col lg:gap-y-6 gap-y-2" id="experts-output">
                <div class="<?php echo isset($slides[0]['image']['url']) && !empty($slides[0]['image']['url']) ? 'bg-[var(--blg-color-primary500)]' : $this->getRandomColorClass(); ?> experts-post-card flex items-end lg:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] overflow-hidden">
                    <img width="100%" height="100%" id="main-image" class="w-full h-full object-cover lg:min-w-[275px] min-w-[164px] min-h-[164px] lg:min-h-[275px] rounded-[var(--blg-radius-3xl)]" src="<?php echo $slides[0]['image']['url']; ?>" alt="">
                </div>
                <div class="flex justify-between items-center text-nowrap bg-[var(--blg-color-primary400)] lg:rounded-[var(--blg-radius-2xl)] rounded-[var(--blg-radius-lg)] lg:py-6 py-4 lg:px-8 px-2">
                    <div class="flex items-center gap-x-1 experts-post-output">
                        <svg xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                            <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
                        </svg>
                        <h4 id="main-name" class="md:text-base text-[12px] font-bold text-[var(--blg-color-primary500)]"><?php echo $slides[0]['name']; ?></h4>
                    </div>
                    <?php if ($this->show_experts_role) : ?>
                        <div id="main-role" class="md:text-[15px] text-[12px] experts-role"><?php echo $slides[0]['role']; ?></div>
                    <?php endif; ?>
                </div>

                <div class="grid grid-cols-2 w-full lg:gap-x-6 gap-x-2 gap-y-2 lg:gap-y-6">
                    <?php if (count($slides) >= 2) : ?>
                        <?php $randomKeys = array_rand($slides, 2); ?>
                        <?php foreach ($randomKeys as $key) : ?>
                            <?php $slide = $slides[$key]; ?>
                            <div class="<?php echo isset($slide['image']['url']) && !empty($slide['image']['url']) ? '!bg-[var(--blg-color-primary500)]' : $this->getRandomColorClass(); ?> experts-post-card flex items-end lg:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] overflow-hidden min-h-[75px] min-w-[75px] lg:min-h-[125px] lg:min-w-[125px] lg:max-w-[125px]">
                                <img width="100%" height="100%" class="grayscale slide-img lg:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)]  w-full h-full object-cover blg-custom-cursor"
                                    src="<?php echo $slide['image']['url']; ?>"
                                    alt=""
                                    data-image="<?php echo $slide['image']['url']; ?>"
                                    data-role="<?php echo $slide['role']; ?>"
                                    data-name="<?php echo esc_html($slide['name']); ?>">
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-span-2">
                <div class="grid grid-cols-2 w-full lg:gap-x-6 gap-x-2 gap-y-2 lg:gap-y-6">
                    <?php $excludedKeys = isset($randomKeys) ? $randomKeys : []; ?>
                    <?php foreach ($slides as $index => $slide): if (in_array($index, $excludedKeys)) continue; ?>
                        <div class="<?php echo isset($slide['image']['url']) && !empty($slide['image']['url']) ? '!bg-[var(--blg-color-primary500)]' : $this->getRandomColorClass(); ?> experts-post-card flex items-end lg:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] overflow-hidden min-h-[75px] min-w-[75px] lg:min-h-[125px] lg:min-w-[125px] lg:max-w-[125px]">
                            <img width="100%" height="100%" class="grayscale slide-img lg:!rounded-[var(--blg-radius-3xl)] !rounded-[var(--blg-radius-xl)] w-full h-full  object-cover blg-custom-cursor"
                                src="<?php echo $slide['image']['url']; ?>"
                                alt=""
                                data-image="<?php echo $slide['image']['url']; ?>"
                                data-role="<?php echo $slide['role']; ?>"
                                data-name="<?php echo esc_html($slide['name']); ?>">
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <div class="w-full h-full relative lg:hidden">
            <div class="absolute top-[0] left-0 rounded-full flex !items-center justify-center bg-gray-300 bg-opacity-50 !shadow-inner !shadow-gray-400/10 !backdrop-blur-[2.0581939220428467px] w-12 h-12">
                <svg xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 24 26" fill="none">
                    <path d="M23.9441 0.361879L21.9859 25.8554L0.887038 11.4128L23.9441 0.361879Z" fill="#78818D" />
                </svg>
            </div>
            <div class="absolute top-[70px] -left-7 w-[24px] h-[24px] bg-[var(--blg-color-secondary200)] rounded-[var(--blg-radius-lg)]"></div>
            <div class="absolute top-20 left-[29px] w-[64px] h-[64px] bg-[var(--blg-color-primary400)] rounded-[6px]"></div>
        </div>
    </div>
</div>

<!-- jQuery Script -->
<script>
    jQuery(document).ready(function() {
        jQuery('.slide-img').click(function() {
            var newImage = jQuery(this).data('image');
            var newName = jQuery(this).data('name');
            var newRole = jQuery(this).data('role');

            jQuery('#main-image').fadeOut(200, function() {
                jQuery(this).attr('src', newImage).fadeIn(200);
            });

            jQuery('#main-name').fadeOut(200, function() {
                jQuery(this).text(newName).fadeIn(200);
            });

            jQuery('#main-role').fadeOut(200, function() {
                jQuery(this).text(newRole).fadeIn(200);
            });
        });
    });
</script>
