<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.6.0
 */

if (!defined('ABSPATH'))
{
    exit;
}
$related_course = BLOGINA_Settings::get('blg_single_show_related_course');

if ($related_products && $related_course) : ?>

    <section class="related products blg-recent">

        <?php
        $heading = apply_filters('woocommerce_product_related_products_heading', __('Related products', 'woocommerce'));

        if ($heading) :
            ?>
            <div class="w-full mb-6 mt-10">
                <div class="flex justify-between items-center">
                    <div class="flex flex-col gap-y-2">
                        <h4 class="lg:text-lg text-md font-bold text-[var(--blg-color-primary500)]">
                            <?php echo $heading; ?>
                        </h4>
                        <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                            <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php woocommerce_product_loop_start(); ?>


        <div class="col-span-12">
            <div class="grid <?php echo BLOGINA_Settings::get('blg_course_archive_style') == 'style1' ? 'xl:grid-cols-4':''; ?> xl:grid-cols-2 md:grid-cols-2 grid-cols-1 md:gap-x-6 gap-y-6">
                <?php foreach ($related_products as $related_product) : ?>

                    <?php
                    $post_object = get_post($related_product->get_id());

                    setup_postdata($GLOBALS['post'] =& $post_object);

                    wc_get_template_part('content', 'product');
                    ?>
                <?php endforeach; ?>
            </div>
        </div>
        <?php woocommerce_product_loop_end(); ?>

    </section>
<?php
endif;

wp_reset_postdata();
?>

