<?php

/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

defined('ABSPATH') || exit;

$customer_id = get_current_user_id();

if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing'  => __('Billing address', 'woocommerce'),
			'shipping' => __('Shipping address', 'woocommerce'),
		),
		$customer_id
	);
} else {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing' => __('Billing address', 'woocommerce'),
		),
		$customer_id
	);
}

$oldcol = 1;
$col    = 1;
?>


<?php if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
	<div class="u-columns woocommerce-Addresses flex flex-col-reverse gap-y-6 col2-set addresses">
	<?php endif; ?>

	<?php foreach ($get_addresses as $name => $address_title) : ?>
		<?php
		$address = wc_get_account_formatted_address($name);
		$col     = $col * -1;
		$oldcol  = $oldcol * -1;
		?>

		<div class="woocommerce-Address text-right flex lg:flex-row flex-col items-center md:gap-x-4 gap-y-4 p-4 bg-[var(--blg-color-primary100)] rounded-2xl">
			<div class="<?php echo $name == 'billing' ? 'bg-[var(--blg-color-primary500)]' : 'bg-white'; ?> p-5 rounded-lg image">
				<?php if ($name == 'billing'): ?>
					<svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
						<path opacity="0.4" d="M33.544 13.781V30.031C33.544 35.031 30.6255 36.6977 27.0222 36.6977H13.9788C10.3755 36.6977 7.45703 35.031 7.45703 30.031V13.781C7.45703 8.36434 10.3755 7.11434 13.9788 7.11434C13.9788 8.14768 14.3863 9.081 15.0548 9.76434C15.7233 10.4477 16.6364 10.8643 17.6472 10.8643H23.3538C25.3755 10.8643 27.0222 9.18101 27.0222 7.11434C30.6255 7.11434 33.544 8.36434 33.544 13.781Z" fill="white" />
						<path d="M27.022 7.11434C27.022 9.18101 25.3753 10.8643 23.3535 10.8643H17.647C16.6361 10.8643 15.723 10.4477 15.0546 9.76434C14.3861 9.081 13.9785 8.14768 13.9785 7.11434C13.9785 5.04768 15.6253 3.36434 17.647 3.36434H23.3535C24.3644 3.36434 25.2775 3.78101 25.946 4.46435C26.6144 5.14768 27.022 6.08101 27.022 7.11434Z" fill="white" />
						<path d="M20.5004 22.9477H13.9787C13.3102 22.9477 12.7559 22.381 12.7559 21.6977C12.7559 21.0143 13.3102 20.4477 13.9787 20.4477H20.5004C21.1689 20.4477 21.7233 21.0143 21.7233 21.6977C21.7233 22.381 21.1689 22.9477 20.5004 22.9477Z" fill="white" />
						<path d="M27.0222 29.6143H13.9787C13.3102 29.6143 12.7559 29.0477 12.7559 28.3643C12.7559 27.681 13.3102 27.1143 13.9787 27.1143H27.0222C27.6906 27.1143 28.245 27.681 28.245 28.3643C28.245 29.0477 27.6906 29.6143 27.0222 29.6143Z" fill="white" />
					</svg>
				<?php else: ?>
					<svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
						<path d="M25.5007 5.03101V20.031C25.5007 21.8643 24.0007 23.3643 22.1673 23.3643H3.83398V10.031C3.83398 6.34767 6.81732 3.36434 10.5007 3.36434H23.834C24.7507 3.36434 25.5007 4.11434 25.5007 5.03101Z" fill="#3A4654" />
						<path opacity="0.4" d="M37.1673 23.3643V28.3643C37.1673 31.131 34.934 33.3643 32.1673 33.3643H30.5007C30.5007 31.531 29.0007 30.031 27.1673 30.031C25.334 30.031 23.834 31.531 23.834 33.3643H17.1673C17.1673 31.531 15.6673 30.031 13.834 30.031C12.0007 30.031 10.5007 31.531 10.5007 33.3643H8.83398C6.06732 33.3643 3.83398 31.131 3.83398 28.3643V23.3643H22.1673C24.0007 23.3643 25.5007 21.8643 25.5007 20.031V8.36434H28.5673C29.7673 8.36434 30.8673 9.01436 31.4673 10.0477L34.3173 15.031H32.1673C31.2507 15.031 30.5007 15.781 30.5007 16.6977V21.6977C30.5007 22.6143 31.2507 23.3643 32.1673 23.3643H37.1673Z" fill="#3A4654" />
						<path d="M13.8333 36.6977C15.6743 36.6977 17.1667 35.2053 17.1667 33.3643C17.1667 31.5234 15.6743 30.031 13.8333 30.031C11.9924 30.031 10.5 31.5234 10.5 33.3643C10.5 35.2053 11.9924 36.6977 13.8333 36.6977Z" fill="#3A4654" />
						<path d="M27.1673 36.6977C29.0083 36.6977 30.5007 35.2053 30.5007 33.3643C30.5007 31.5234 29.0083 30.031 27.1673 30.031C25.3264 30.031 23.834 31.5234 23.834 33.3643C23.834 35.2053 25.3264 36.6977 27.1673 36.6977Z" fill="#3A4654" />
						<path d="M37.1667 20.9144V23.3643H32.1667C31.25 23.3643 30.5 22.6143 30.5 21.6977V16.6977C30.5 15.781 31.25 15.031 32.1667 15.031H34.3167L36.7333 19.2643C37.0167 19.7643 37.1667 20.3311 37.1667 20.9144Z" fill="#3A4654" />
					</svg>
				<?php endif; ?>
			</div>
			<div class="md:text-[15px] text-sm font-normal text-[var(--blg-gray)] texts lg:flex-row flex-col">
				<address class="text-[var(--blg-gray)] font-['YekanBakh'] font-medium">
					<?php echo $address ? wp_kses_post($address) : esc_html_e('You have not set up this type of address yet.', 'woocommerce'); ?>
					<?php do_action('woocommerce_my_account_after_my_address', $name); ?>
				</address>
				<a class="edit <?php echo $name == 'billing' ? 'bg-[var(--blg-color-primary500)] text-white' : 'border-[1px] border-solid border-[var(--blg-color-primary500)]'; ?> rounded-lg flex gap-x-4 items-center px-8 py-[10px]" href="<?php echo esc_url(wc_get_endpoint_url('edit-address', $name)); ?>" class="text-sm text-[var(--blg-color-primary500)] underline">
					<?php if (!$address): ?>
						<?php if ($name == 'billing'): ?>
							<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
								<path d="M6.35938 12.531H18.3594" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M12.3594 18.531V6.53101" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>
						<?php else: ?>
							<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
								<path d="M6.28125 12.5309H18.2812" stroke="#3A4654" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M12.2812 18.5309V6.53088" stroke="#3A4654" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>
						<?php endif; ?>
					<?php endif; ?>
					<?php
					printf(
						/* translators: %s: Address title */
						$address ? esc_html__('Edit %s', 'woocommerce') : esc_html__('Add %s', 'woocommerce'),
						esc_html($address_title)
					);
					?>

				</a>
			</div>

		</div>
	<?php endforeach; ?>

	<?php if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
	</div>
<?php
	endif;
