<?php

/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/downloads.php.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.8.0
 */

if (! defined('ABSPATH')) {
	exit;
}

$downloads     = WC()->customer->get_downloadable_products();
$has_downloads = (bool) $downloads;

do_action('woocommerce_before_account_downloads', $has_downloads);

?>
<div class="mx-auto <?php echo $has_downloads ?  '!bg-white' : 'bg-[var(--blg-color-primary100)] flex items-center justify-center flex-col px-48 py-40'; ?> p-6 blg-shadow-sm rounded-[var(--blg-radius-3xl)] my-4">
	<?php
	if ($has_downloads) :
	?>

		<div class="woocommerce-downloads grid grid-cols-1 gap-6">
			<?php foreach ($downloads as $download) :
				$product_id = $download['product_id'];
				$product = wc_get_product($product_id);
				$product_thumbnail = $product ? $product->get_image() : '';
				$product_category = '';
				if ($product) {
					$categories = get_the_terms($product_id, 'product_cat');
					if (!empty($categories) && !is_wp_error($categories)) {
						$product_category = $categories[0]->name; // Get the name of the first category
					}
				}
			?>

				<div class="woocommerce-download-item rounded-[var(--blg-radius-2xl)] flex md:flex-row flex-col md:items-center lg:gap-x-5 3xl:gap-x-[100px] gap-x-2 gap-y-4 border-b bg-[var(--blg-color-primary100)] p-4">
					<div class="product-thumbnail rounded-2xl max-w-[85px] min-w-[85px]">
						<?php
						if ($download['file']['file'])
							printf('<a href="%s">%s</a>', esc_url($download['download_url']), wp_kses_post($product_thumbnail));
						?>
					</div>
					<div class="product-title flex items-center gap-x-2 whitespace-nowrap border-l-2 border-[var(--blg-color-primary400)] pl-4">
						<div class="flex flex-col gap-y-2">
							<div class="font-bold text-[var(--blg-color-primary500)]">
								<a href="<?php echo esc_url($download['product_url']); ?>">
									<?php echo esc_html($download['product_name']); ?>
								</a>
							</div>

							<div class="product-category text-[var(--blg-gray)] font-medium font-['YekanBakh'] text-[15px]">
								<?php echo esc_html__('Category: ', BLOGINA_TEXT_DOMAIN) . $product_category; ?>
							</div>
						</div>
					</div>

					<div class="product-download-status w-full flex flex-col gap-y-2 border-l-2 border-[var(--blg-color-primary400)] px-4">
						<h4 class="font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Downloads remaining:', BLOGINA_TEXT_DOMAIN); ?></h4>
						<span class="text-[var(--blg-gray)] font-medium text-[15px] font-['YekanBakh']">
							<?php echo $download['downloads_remaining'] ? esc_html($download['downloads_remaining']) . ' ' . esc_html__('numbers', BLOGINA_TEXT_DOMAIN) : esc_html__('Unlimited', 'woocommerce'); ?>
						</span>
					</div>

					<div class="product-access-expiration w-full flex flex-col gap-y-2 border-l-2 border-[var(--blg-color-primary400)] px-4">
						<h4 class="font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Access expires:', BLOGINA_TEXT_DOMAIN); ?></h4>
						<span class="text-[var(--blg-gray)] font-medium text-[15px] font-['YekanBakh']">
							<?php echo $download['access_expires'] ? esc_html(date_i18n(get_option('date_format'), strtotime($download['access_expires']))) : esc_html__('Never', BLOGINA_TEXT_DOMAIN); ?>
						</span>
					</div>

					<div class="product-remove w-full flex items-center gap-2 whitespace-nowrap px-4">
						<a href="<?php echo esc_url($download['product_url']); ?>" class="text-[var(--blg-color-primary500)] border rounded-lg text-base border-[var(--blg-color-primary500)] px-2.5 py-2">
							<?php esc_html_e('Product Details', 'woocommerce'); ?>
						</a>
						<a href="<?php echo esc_url($download['download_url']); ?>" class="text-[var(--blg-color-primary500)] border rounded-lg text-base border-[var(--blg-color-primary500)] px-2.5 py-2">
							<?php esc_html_e('Download', 'woocommerce'); ?>
						</a>
					</div>

				</div>

			<?php endforeach; ?>
		</div>

	<?php else : ?>


		<div class="flex flex-col gap-y-4 items-center justify-center">
			<span>
				<svg xmlns="http://www.w3.org/2000/svg" width="160" height="160" viewBox="0 0 160 160" fill="none">
					<path opacity="0.4" d="M112.001 59.9934H48.0007C26.6673 59.9934 13.334 73.3267 13.334 94.6601V111.927C13.334 133.327 26.6673 146.66 48.0007 146.66H111.934C133.267 146.66 146.601 133.327 146.601 111.993V94.6601C146.667 73.3267 133.334 59.9934 112.001 59.9934Z" fill="#3A4654" />
					<path d="M105.867 82.86L83.5336 105.193C81.6003 107.127 78.4003 107.127 76.4669 105.193L54.1336 82.86C52.2003 80.9267 52.2003 77.7267 54.1336 75.7933C56.0669 73.86 59.2669 73.86 61.2003 75.7933L75.0003 89.5933V18.3267C75.0003 15.5933 77.2669 13.3267 80.0003 13.3267C82.7336 13.3267 85.0003 15.5933 85.0003 18.3267V89.5933L98.8003 75.7933C99.8003 74.7933 101.067 74.3267 102.334 74.3267C103.6 74.3267 104.867 74.7933 105.867 75.7933C107.867 77.7267 107.867 80.86 105.867 82.86Z" fill="#3A4654" />
				</svg>
			</span>
			<span class="font-['Pinar'] font-bold text-[var(--blg-color-primary500)] md:text-xl text-lg">
				<?php esc_html_e('No downloads available yet.', 'woocommerce'); ?>
			</span>
		</div>
	<?php endif; ?>

	<?php do_action('woocommerce_after_account_downloads', $has_downloads); ?>
</div>