<?php

/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order $order
 */

defined('ABSPATH') || exit;
?>


<div class="woocommerce-order blg-shadow-sm bg-white md:px-8 px-4 md:py-8 py-4 rounded-[var(--blg-radius-3xl)]">

	<?php
	if ($order) :

		do_action('woocommerce_before_thankyou', $order->get_id());
	?>

		<?php if ($order->has_status('failed')) : ?>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed text-red-600"><?php esc_html_e('Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce'); ?></p>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions mt-4">
				<a href="<?php echo esc_url($order->get_checkout_payment_url()); ?>" class="button pay bg-blue-500 hover:bg-blue-600 text-white py-2 px-4 rounded"><?php esc_html_e('Pay', 'woocommerce'); ?></a>
				<?php if (is_user_logged_in()) : ?>
					<a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="button pay bg-gray-300 hover:bg-gray-400 text-gray-800 py-2 px-4 rounded"><?php esc_html_e('My account', 'woocommerce'); ?></a>
				<?php endif; ?>
			</p>

		<?php else : ?>

			<?php wc_get_template('checkout/order-received.php', array('order' => $order)); ?>

			<ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details flex lg:flex-row flex-col !gap-y-8 !gap-x-10 !my-4 bg-[var(--blg-color-primary100)] rounded-[var(--blg-radius-3xl)] px-8 py-9">

				<li class="woocommerce-order-overview__order max-lg:!border-none order flex lg:flex-col flex-row items-start whitespace-nowrap gap-x-2 !gap-y-4">
					<span class="!font-['Pinar'] md:!text-[18px] !text-sm text-[var(--blg-color-primary500)] font-bold">
						<?php esc_html_e('Order number:', 'woocommerce'); ?>
					</span>
					<span class="!text-[var(--blg-gray)] md:!text-[15px] !text-xs !font-medium"><?php echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
																							?></span>
				</li>

				<li class="woocommerce-order-overview__date max-lg:!border-none date flex lg:flex-col flex-row items-start whitespace-nowrap !gap-x-2 !gap-y-4">
					<span class="!font-['Pinar'] md:!text-[18px] !text-sm text-[var(--blg-color-primary500)] font-bold">
						<?php esc_html_e('Date:', 'woocommerce'); ?>
					</span>
					<span class="!text-[var(--blg-gray)] md:!text-[15px] !text-xs !font-medium"><?php echo BLOGINA_JALALI::display_jalali_date($order->get_date_created()); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
																							?></span>
				</li>

				<?php if (is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email()) : ?>
					<li class="woocommerce-order-overview__email email max-lg:!border-none flex lg:flex-col flex-row items-start whitespace-nowrap gap-x-2 !gap-y-4">
						<span class="!font-['Pinar'] md:!text-[18px] !text-sm text-[var(--blg-color-primary500)] font-bold">

							<?php esc_html_e('Email:', 'woocommerce'); ?>
						</span>
						<span class="!text-[var(--blg-gray)] md:!text-[15px] !text-xs !font-medium"><?php echo $order->get_billing_email(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
																								?></span>
					</li>
				<?php endif; ?>

				<li class="woocommerce-order-overview__total max-lg:!border-none total flex lg:flex-col flex-row items-start whitespace-nowrap gap-x-2 !gap-y-4">
					<span class="!font-['Pinar'] md:!text-[18px] !text-sm text-[var(--blg-color-primary500)] font-bold">
						<?php esc_html_e('Total:', 'woocommerce'); ?>
					</span>
					<span class="!text-[var(--blg-gray)] md:!text-[15px] !text-xs !font-medium"><?php echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
																							?></span>
				</li>

				<?php if ($order->get_payment_method_title()) : ?>
					<li class="woocommerce-order-overview__payment-method max-lg:!border-none method flex lg:flex-col flex-row items-start whitespace-nowrap gap-x-2 !gap-y-4">
						<span class="!font-['Pinar'] md:!text-[18px] !text-sm text-[var(--blg-color-primary500)] font-bold">
							<?php esc_html_e('Payment method:', 'woocommerce'); ?>
						</span>
						<span class="!text-[var(--blg-gray)] md:!text-[15px] !text-xs !font-medium"><?php echo wp_kses_post($order->get_payment_method_title()); ?></span>
					</li>
				<?php endif; ?>

			</ul>

		<?php endif; ?>
		<div class="w-full h-[1px] bg-[var(--blg-color-primary500)] opacity-10 my-10"></div>

		<div class="w-full my-2">
			<div class="flex justify-between items-center">
				<div class="flex flex-col gap-y-2">
					<h1 class="md:text-xl text-md font-bold text-[var(--blg-color-primary500)]"><?php do_action('woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id()); ?></h1>
					<div class="h-[1px] bg-[#E4E4E4] w-full relative">
						<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
					</div>
				</div>
			</div>
		</div>
		<?php do_action('woocommerce_thankyou', $order->get_id()); ?>

	<?php else : ?>

		<?php wc_get_template('checkout/order-received.php', ['order' => false]); ?>

	<?php endif; ?>

</div>