<?php

/**
 * Review order table
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/review-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.2.0
 */

defined('ABSPATH') || exit;
// Set a default order button text if not already set
$order_button_text = isset($order_button_text) && !empty($order_button_text) ? $order_button_text : __('Place Order', BLOGINA_TEXT_DOMAIN);

?>
<table class="shop_table woocommerce-checkout-review-order-table !blg-shadow-sm !bg-white md:!px-8 !px-2 md:!py-8 py-!2 lg:!rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)]">
	<tbody>
		<?php
		do_action('woocommerce_review_order_before_cart_contents');

		foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
			$_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);

			if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key)) {
		?>
				<tr class="<?php echo esc_attr(apply_filters('woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key)); ?>">
					<td colspan="2" class="product-total py-5">
						<div class="flex !justify-between items-center md:text-xl text-sm font-semibold text-[var(--blg-color-primary500)]">
							<div class="flex gap-x-2 items-center font-semibold md:text-base text-[15px] !border-none text-[var(--blg-gray)]">
								<?php echo wp_kses_post(apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key)) . '&nbsp;'; ?>
								<?php echo apply_filters('woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf('&times;&nbsp;%s', $cart_item['quantity']) . '</strong>', $cart_item, $cart_item_key); ?>
								<?php echo wc_get_formatted_cart_item_data($cart_item); ?>
							</div>
							<?php echo apply_filters('woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal($_product, $cart_item['quantity']), $cart_item, $cart_item_key); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
							?>
						</div>
					</td>
				</tr>
		<?php
			}
		}

		do_action('woocommerce_review_order_after_cart_contents');
		?>
	</tbody>
	<tfoot>

		<tr class="cart-subtotal text-right">
			<td colspan="2" class="text-right py-5">
				<div class="flex !justify-between items-center md:text-xl text-sm font-semibold text-[var(--blg-color-primary500)]">
					<span class="font-semibold md:text-base text-[15px] !border-none text-[var(--blg-gray)]"><?php esc_html_e('Subtotal', 'woocommerce'); ?></span>
					<?php wc_cart_totals_subtotal_html(); ?>
				</div>
			</td>
		</tr>

		<?php foreach (WC()->cart->get_coupons() as $code => $coupon) : ?>
			<tr class="cart-discount coupon-<?php echo esc_attr(sanitize_title($code)); ?>">
				<td colspan="2" class="text-right py-5">
					<div class="flex !justify-between items-center md:text-xl text-sm font-semibold text-[var(--blg-color-primary500)]">
						<span class="font-semibold md:text-base text-[15px] !border-none text-[var(--blg-gray)]"><?php wc_cart_totals_coupon_label($coupon); ?> </span>
						<?php wc_cart_totals_coupon_html($coupon); ?>
					</div>
				</td>
			</tr>
		<?php endforeach; ?>

		<?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) : ?>

			<?php do_action('woocommerce_review_order_before_shipping'); ?>

			<?php wc_cart_totals_shipping_html(); ?>

			<?php do_action('woocommerce_review_order_after_shipping'); ?>

		<?php endif; ?>

		<?php foreach (WC()->cart->get_fees() as $fee) : ?>
			<tr class="fee">
				<td colspan="2" class="text-right py-5">
					<div class="flex !justify-between items-center md:text-xl text-sm font-semibold text-[var(--blg-color-primary500)]">
						<span class="font-semibold md:text-base text-[15px] !border-none text-[var(--blg-gray)]"><?php echo esc_html($fee->name); ?></span>
						<?php wc_cart_totals_fee_html($fee); ?>
					</div>
				</td>
			</tr>
		<?php endforeach; ?>

		<?php if (wc_tax_enabled() && ! WC()->cart->display_prices_including_tax()) : ?>
			<?php if ('itemized' === get_option('woocommerce_tax_total_display')) : ?>
				<?php foreach (WC()->cart->get_tax_totals() as $code => $tax) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited 
				?>
					<tr class="tax-rate tax-rate-<?php echo esc_attr(sanitize_title($code)); ?>">
						<td colspan="2" class="text-right py-5">
							<div class="flex !justify-between items-center md:text-xl text-sm font-semibold text-[var(--blg-color-primary500)]">
								<span class="font-semibold md:text-base text-[15px] !border-none text-[var(--blg-gray)]"><?php echo esc_html($tax->label); ?></span>
								<?php echo wp_kses_post($tax->formatted_amount); ?>
							</div>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php else : ?>
				<tr class="tax-total text-right">
					<td colspan="2" class="text-right py-5">
						<div class="flex !justify-between items-center md:text-xl text-sm font-semibold text-[var(--blg-color-primary500)]">
							<span class="font-semibold md:text-base text-[15px] !border-none text-[var(--blg-gray)]">
								<?php echo esc_html(WC()->countries->tax_or_vat()); ?>
							</span>
							<?php wc_cart_totals_taxes_total_html(); ?>
						</div>
					</td>
				</tr>
			<?php endif; ?>
		<?php endif; ?>

		<?php do_action('woocommerce_review_order_before_order_total'); ?>

		<tr class="order-total text-right">
			<td colspan="2" data-title="<?php esc_attr_e('Total', 'woocommerce'); ?>" class="rounded-lg !border-none !py-5 !px-4 text-right md:text-lg text-md font-semibold bg-[var(--blg-color-primary100)]">
				<div class="flex !justify-between items-center md:text-xl text-sm font-semibold px-4 text-[var(--blg-color-secondary200)]">
					<span class="font-bold md:text-lg text-md font-['Pinar'] !border-none text-[var(--blg-color-primary500)]">
						<?php esc_html_e('Total', 'woocommerce'); ?>
					</span>
					<?php wc_cart_totals_order_total_html(); ?>
				</div>
			</td>
		</tr>

		<?php do_action('woocommerce_review_order_after_order_total'); ?>

		<tr>
			<td colspan="2">
				<div class="form-row place-order flex w-full justify-center">
					<noscript>
						<?php
						/* translators: $1 and $2 opening and closing emphasis tags respectively */
						printf(esc_html__('Since your browser does not support JavaScript, or it is disabled, please ensure you click the %1$sUpdate Totals%2$s button before placing your order. You may be charged more than the amount stated above if you fail to do so.', 'woocommerce'), '<em>', '</em>');
						?>
						<br />
						<button type="submit" class="button alt bg-blue-600 text-white hover:bg-blue-700 px-4 py-2 rounded mt-2" name="woocommerce_checkout_update_totals" value="<?php esc_attr_e('Update totals', 'woocommerce'); ?>"><?php esc_html_e('Update totals', 'woocommerce'); ?></button>
					</noscript>

					<?php //wc_get_template('checkout/terms.php'); 
					?>

					<?php do_action('woocommerce_review_order_before_submit'); ?>

					<?php
					echo apply_filters(
						'woocommerce_order_button_html',
						'<button type="submit" class="button alt flex items-center justify-center text-white !px-12 !py-4 !blg-btn-secondary"
						name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr($order_button_text) . '" 
						data-value="' . esc_attr($order_button_text) . '">' . esc_html($order_button_text) . '</button>'
					);
					?>

					<?php do_action('woocommerce_review_order_after_submit'); ?>

					<?php wp_nonce_field('woocommerce-process_checkout', 'woocommerce-process-checkout-nonce'); ?>
				</div>

			</td>
		</tr>
	</tfoot>

</table>