<?php

/**
 * Checkout Payment Section
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/payment.php.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 */

defined('ABSPATH') || exit;

if (! wp_doing_ajax()) {
	do_action('woocommerce_review_order_before_payment');
}
?>
<div id="payment" class="woocommerce-checkout-payment blg-shadow-sm !bg-white md:px-8 px-2 md:py-8 py-2 !rounded-[var(--blg-radius-3xl)] mt-6">
	<div class="w-full my-2">
		<div class="flex justify-between items-center">
			<div class="flex flex-col gap-y-2">
				<h4 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Select Payment Method', BLOGINA_TEXT_DOMAIN); ?></h4>
				<div class="h-[1px] bg-[#E4E4E4] w-full relative">
					<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
				</div>
			</div>
		</div>
	</div>
	<div class="payment_methods_box">
		<?php if (WC()->cart->needs_payment()) : ?>
			<ul class="wc_payment_methods payment_methods methods flex flex-col gap-y-4">
				<?php
				if (! empty($available_gateways)) {
					foreach ($available_gateways as $gateway) {
						wc_get_template('checkout/payment-method.php', array('gateway' => $gateway));
					}
				} else {
					echo '<li class="text-red-600">';
					wc_print_notice(apply_filters('woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__('Sorry, it seems that there are no available payment methods. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce') : esc_html__('Please fill in your details above to see available payment methods.', 'woocommerce')), 'notice'); // phpcs:ignore WooCommerce.Commenting.CommentHooks.MissingHookComment
					echo '</li>';
				}
				?>
			</ul>
		<?php endif; ?>

		<?php wc_get_template( 'checkout/terms.php' ); ?>


	</div>

</div>
<?php
if (! wp_doing_ajax()) {
	do_action('woocommerce_review_order_after_payment');
}
