<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINA_Course $this */

global $product;

$post_id = get_the_ID();
$common_questions = BLOGINA_Course::get_faq();
?>
<?php if (is_array($common_questions)): ?>
    <div class="grid grid-cols-1">
        <div class="bg-white gap-x-8 gap-y-2 p-6 my-10 blg-shadow-sm rounded-[var(--blg-radius-3xl)] overflow-hidden">
            <div class="flex justify-between items-center my-4">
                <div class="flex flex-col gap-y-2">
                    <h2 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Common Questions', BLOGINA_TEXT_DOMAIN); ?></h2>
                    <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                        <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                    </div>
                </div>
            </div>

            <!-- blg-Accordion Start -->
            <?php foreach ($common_questions as $key => $qa): ?>
                <div class="blg-accordion flex flex-col gap-y-2 mt-6">
                    <div class="blg-accordion-item bg-[var(--blg-color-primary100)] rounded-2xl">
                        <h3 class="blg-accordion-header">
                            <button aria-label="quesion"
                                    class="blg-accordion-button flex justify-between rounded-none items-center w-full py-5 px-5 text-[var(--blg-color-primary500)] font-normal text-[15px] transition-all duration-300"
                                    type="button" data-target="#blg-accordion-item-qa-<?php echo $key; ?>"
                                    aria-expanded="false">
                                <?php echo $qa['question']; ?>
                                <span class="blg-accordion-icon text-3xl">+</span>
                            </button>
                        </h3>
                        <div id="blg-accordion-item-qa-<?php echo $key; ?>"
                             class="blg-accordion-content border-t  border-[var(--blg-color-primary400)] hidden px-4 py-4 text-[var(--blg-gray)] ont-normal text-[15px]">
                            <p class="text-justify"><?php echo $qa['answer']; ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>
