<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINA_Course $this */

global $product;

$post_id = get_the_ID();
$display_options = BLOGINA_Course::get_display_options();
$show_pre_course = $display_options['show_pre_course'] ?? 1;
$show_course_status = $display_options['show_course_status'] ?? 1;
$show_last_update = $display_options['show_last_update'] ?? 1;
$show_view_type = $display_options['show_view_type'] ?? 1;
$show_learn = $display_options['show_learn'] ?? 1;
$show_support_type = $display_options['show_support_type'] ?? 1;
$show_start_date = $display_options['show_start_date'] ?? 0;
$show_end_date = $display_options['show_end_date'] ?? 0;
$show_course_duration = $display_options['show_course_duration'] ?? 0;
$show_chapter_counts = $display_options['show_chapter_counts'] ?? 0;
$show_session_counts = $display_options['show_session_counts'] ?? 0;
$show_as_slider = $display_options['show_as_slider'] ?? 0;

?>
<div class="<?php echo $show_as_slider ? 'single-details-swiper-container overflow-x-hidden' : 'grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-x-[29px] gap-y-[29px]'; ?>">
    <?php echo $show_as_slider ? '<div class="swiper-wrapper">': ''; ?>

        <?php if($show_course_status): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
            <div class="flex items-center gap-x-4 w-full">
                <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path opacity="0.4"
                              d="M14.6134 2.75887L7.28007 5.50554C5.88007 6.03887 4.7334 7.69221 4.7334 9.19887V19.9989C4.7334 21.0789 5.44007 22.5055 6.30673 23.1455L13.6401 28.6255C14.9334 29.5989 17.0534 29.5989 18.3467 28.6255L25.6801 23.1455C26.5467 22.4922 27.2534 21.0789 27.2534 19.9989V9.19887C27.2534 7.70554 26.1067 6.03887 24.7067 5.51887L17.3734 2.77221C16.6267 2.47887 15.3734 2.47887 14.6134 2.75887Z"
                              fill="white" />
                        <path d="M14.2136 18.9854C13.9603 18.9854 13.707 18.892 13.507 18.692L11.3603 16.5454C10.9736 16.1587 10.9736 15.5187 11.3603 15.132C11.747 14.7454 12.387 14.7454 12.7736 15.132L14.2136 16.572L19.2403 11.5454C19.627 11.1587 20.267 11.1587 20.6536 11.5454C21.0403 11.932 21.0403 12.572 20.6536 12.9587L14.9203 18.692C14.7203 18.892 14.467 18.9854 14.2136 18.9854Z"
                              fill="white" />
                    </svg>
                </div>
                <div class="flex flex-col">
                    <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('Course Status', BLOGINA_TEXT_DOMAIN); ?></h4>
                    <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo esc_html__(BLOGINA_Course::get_course_status(), BLOGINAC_TEXT_DOMAIN); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if($show_last_update): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
            <div class="flex items-center gap-x-4 w-full">
                <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path opacity="0.4"
                              d="M16.0003 29.3456C23.3641 29.3456 29.3337 23.3761 29.3337 16.0123C29.3337 8.64849 23.3641 2.67896 16.0003 2.67896C8.63653 2.67896 2.66699 8.64849 2.66699 16.0123C2.66699 23.3761 8.63653 29.3456 16.0003 29.3456Z"
                              fill="white" />
                        <path d="M20.9462 21.2521C20.7729 21.2521 20.5995 21.2121 20.4395 21.1054L16.3062 18.6387C15.2795 18.0254 14.5195 16.6787 14.5195 15.4921V10.0254C14.5195 9.47872 14.9729 9.02539 15.5195 9.02539C16.0662 9.02539 16.5195 9.47872 16.5195 10.0254V15.4921C16.5195 15.9721 16.9195 16.6787 17.3329 16.9187L21.4662 19.3854C21.9462 19.6654 22.0929 20.2787 21.8129 20.7587C21.6129 21.0787 21.2795 21.2521 20.9462 21.2521Z"
                              fill="white" />
                    </svg>
                </div>
                <div class="flex flex-col">
                    <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('Last Update', BLOGINA_TEXT_DOMAIN); ?></h4>
                    <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo BLOGINA_Post::get_last_update($post_id); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if($show_view_type): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
            <div class="flex items-center gap-x-4 w-full">
                <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path opacity="0.4"
                              d="M28.3337 12.2122C25.2537 7.37221 20.747 4.58554 16.0003 4.58554C13.627 4.58554 11.3203 5.27887 9.21366 6.57221C7.10699 7.87887 5.21366 9.78554 3.66699 12.2122C2.33366 14.3055 2.33366 17.7055 3.66699 19.7989C6.74699 24.6522 11.2537 27.4255 16.0003 27.4255C18.3737 27.4255 20.6803 26.7322 22.787 25.4389C24.8937 24.1322 26.787 22.2255 28.3337 19.7989C29.667 17.7189 29.667 14.3055 28.3337 12.2122ZM16.0003 21.3989C13.0137 21.3989 10.6137 18.9855 10.6137 16.0122C10.6137 13.0389 13.0137 10.6255 16.0003 10.6255C18.987 10.6255 21.387 13.0389 21.387 16.0122C21.387 18.9855 18.987 21.3989 16.0003 21.3989Z"
                              fill="white" />
                        <path d="M16.0002 12.1989C13.9069 12.1989 12.2002 13.9055 12.2002 16.0122C12.2002 18.1055 13.9069 19.8122 16.0002 19.8122C18.0935 19.8122 19.8135 18.1055 19.8135 16.0122C19.8135 13.9189 18.0935 12.1989 16.0002 12.1989Z"
                              fill="white" />
                    </svg>
                </div>
                <div class="flex flex-col">
                    <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php echo esc_html__('View Type', BLOGINA_TEXT_DOMAIN); ?></h4>
                    <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo esc_html__(BLOGINA_Course::get_watch_type(), BLOGINAC_TEXT_DOMAIN); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if($show_support_type): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
            <div class="flex items-center gap-x-4 w-full">
                <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path opacity="0.4"
                              d="M24 25.1588H22.9867C21.92 25.1588 20.9067 25.5722 20.16 26.3188L17.88 28.5722C16.84 29.5988 15.1467 29.5988 14.1067 28.5722L11.8267 26.3188C11.08 25.5722 10.0533 25.1588 9 25.1588H8C5.78667 25.1588 4 23.3856 4 21.1989V6.65218C4 4.46551 5.78667 2.69221 8 2.69221H24C26.2133 2.69221 28 4.46551 28 6.65218V21.1989C28 23.3722 26.2133 25.1588 24 25.1588Z"
                              fill="white" />
                        <path d="M13.8403 19.359H10.267C9.6803 19.359 9.13363 19.079 8.78697 18.599C8.45363 18.1456 8.37363 17.5857 8.53363 17.0523C9.0003 15.6257 10.147 14.8523 11.1603 14.1589C12.227 13.4389 12.827 12.9857 12.827 12.2123C12.827 11.519 12.267 10.959 11.5736 10.959C10.8803 10.959 10.3203 11.519 10.3203 12.2123C10.3203 12.759 9.86698 13.2123 9.32031 13.2123C8.77365 13.2123 8.32031 12.759 8.32031 12.2123C8.32031 10.4257 9.77363 8.95898 11.5736 8.95898C13.3736 8.95898 14.827 10.4123 14.827 12.2123C14.827 14.0923 13.4136 15.0523 12.2803 15.8256C11.5736 16.3056 10.907 16.759 10.5736 17.359H13.827C14.3736 17.359 14.827 17.8123 14.827 18.359C14.827 18.9056 14.387 19.359 13.8403 19.359Z"
                              fill="white" />
                        <path d="M21.3871 19.359C20.8405 19.359 20.3871 18.9056 20.3871 18.359V17.439H17.7738C17.7738 17.439 17.7738 17.439 17.7605 17.439C17.1072 17.439 16.5072 17.0923 16.1738 16.5323C15.8405 15.959 15.8405 15.2523 16.1738 14.6923C17.0805 13.1323 18.1338 11.3589 19.0938 9.81225C19.5205 9.13225 20.3338 8.82564 21.0938 9.03897C21.8538 9.26564 22.3872 9.95894 22.3738 10.7589V15.4523H22.6672C23.2138 15.4523 23.6672 15.9056 23.6672 16.4523C23.6672 16.999 23.2138 17.4523 22.6672 17.4523H22.3871V18.3723C22.3871 18.919 21.9471 19.359 21.3871 19.359ZM20.3871 11.5323C19.6005 12.8123 18.7871 14.1856 18.0538 15.439H20.3871V11.5323Z"
                              fill="white" />
                    </svg>
                </div>
                <div class="flex flex-col">
                    <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('Support Type', BLOGINA_TEXT_DOMAIN); ?></h4>
                    <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo esc_html__(BLOGINA_Course::get_support_type(), BLOGINAC_TEXT_DOMAIN); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if($show_pre_course): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
            <div class="flex items-center gap-x-4 w-full">
                <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path opacity="0.4"
                              d="M28.6663 11.172V21.1054C28.6663 21.3054 28.5997 21.5054 28.4263 21.6787C26.493 23.6254 23.053 27.092 21.0797 29.0787C20.9063 29.2654 20.6797 29.3454 20.453 29.3454H9.82634C6.23967 29.3454 3.33301 26.4387 3.33301 22.852V11.172C3.33301 7.58538 6.23967 4.67871 9.82634 4.67871H22.173C25.7597 4.67871 28.6663 7.58538 28.6663 11.172Z"
                              fill="white" />
                        <path d="M11.0537 8.39871C10.4937 8.39871 10.0537 7.94538 10.0537 7.39871V3.67871C10.0537 3.13204 10.4937 2.67871 11.0537 2.67871C11.6137 2.67871 12.0537 3.13204 12.0537 3.67871V7.38538C12.0537 7.94538 11.6137 8.39871 11.0537 8.39871Z"
                              fill="white" />
                        <path d="M20.9463 8.39871C20.3863 8.39871 19.9463 7.94538 19.9463 7.39871V3.67871C19.9463 3.11871 20.3996 2.67871 20.9463 2.67871C21.5063 2.67871 21.9463 3.13204 21.9463 3.67871V7.38538C21.9463 7.94538 21.5063 8.39871 20.9463 8.39871Z"
                              fill="white" />
                        <path d="M19.7068 16.9589H9.81348C9.25348 16.9589 8.81348 16.5055 8.81348 15.9589C8.81348 15.4122 9.26681 14.9589 9.81348 14.9589H19.7068C20.2668 14.9589 20.7068 15.4122 20.7068 15.9589C20.7068 16.5055 20.2668 16.9589 19.7068 16.9589Z"
                              fill="white" />
                        <path d="M16.0001 21.9055H9.81348C9.25348 21.9055 8.81348 21.4522 8.81348 20.9055C8.81348 20.3455 9.26681 19.9055 9.81348 19.9055H16.0001C16.5601 19.9055 17.0001 20.3589 17.0001 20.9055C17.0001 21.4522 16.5601 21.9055 16.0001 21.9055Z"
                              fill="white" />
                        <path d="M28.6669 21.1058C28.6669 21.3058 28.6002 21.5058 28.4269 21.6791C26.4936 23.6258 23.0536 27.0924 21.0802 29.0791C20.9069 29.2658 20.6802 29.3458 20.4536 29.3458C20.0136 29.3458 19.5869 28.9991 19.5869 28.4924V23.8258C19.5869 21.8791 21.2402 20.2658 23.2669 20.2658C24.5336 20.2524 26.2936 20.2524 27.8002 20.2524C28.3202 20.2524 28.6669 20.6658 28.6669 21.1058Z"
                              fill="white" />
                    </svg>
                </div>
                <div class="flex flex-col">
                    <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('Required course', BLOGINA_TEXT_DOMAIN); ?></h4>
                    <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo BLOGINA_Course::get_required_course(); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if($show_learn): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
            <div class="flex items-center gap-x-4 w-full">
                <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path opacity="0.4"
                              d="M28.0539 9.59888L16.0006 16.5722L3.94727 9.59888C4.4806 8.61221 5.25393 7.74555 6.1206 7.26555L13.2406 3.31888C14.7606 2.46555 17.2406 2.46555 18.7606 3.31888L25.8806 7.26555C26.7473 7.74555 27.5206 8.61221 28.0539 9.59888Z"
                              fill="white" />
                        <path opacity="0.6"
                              d="M16.0008 16.5722V29.3455C15.0008 29.3455 14.0008 29.1322 13.2408 28.7055L6.12083 24.7589C4.5075 23.8655 3.1875 21.6255 3.1875 19.7855V12.2389C3.1875 11.3855 3.48083 10.4522 3.9475 9.59888L16.0008 16.5722Z"
                              fill="white" />
                        <path d="M28.8143 12.2389V19.7855C28.8143 21.6255 27.4943 23.8655 25.881 24.7589L18.761 28.7055C18.001 29.1322 17.001 29.3455 16.001 29.3455V16.5722L28.0543 9.59888C28.521 10.4522 28.8143 11.3855 28.8143 12.2389Z"
                              fill="white" />
                    </svg>
                </div>
                <div class="flex flex-col">
                    <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('Learn', BLOGINA_TEXT_DOMAIN); ?></h4>
                    <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo BLOGINA_Course::get_course_type($post_id); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php if($show_start_date): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
                <div class="flex items-center gap-x-4 w-full">
                    <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 32" fill="none">
                            <path opacity="0.4"
                                  d="M22 4H10C7.79 4 6 5.79 6 8V24C6 26.21 7.79 28 10 28H22C24.21 28 26 26.21 26 24V8C26 5.79 24.21 4 22 4Z"
                                  fill="white" />
                            <path d="M22 2C22.55 2 23 2.45 23 3V5C23 5.55 22.55 6 22 6C21.45 6 21 5.55 21 5V3C21 2.45 21.45 2 22 2ZM10 2C10.55 2 11 2.45 11 3V5C11 5.55 10.55 6 10 6C9.45 6 9 5.55 9 5V3C9 2.45 9.45 2 10 2Z"
                                  fill="white" />
                            <path d="M6 10H26V24C26 26.21 24.21 28 22 28H10C7.79 28 6 26.21 6 24V10ZM10 15H12C12.55 15 13 15.45 13 16C13 16.55 12.55 17 12 17H10C9.45 17 9 16.55 9 16C9 15.45 9.45 15 10 15ZM14 15H22C22.55 15 23 15.45 23 16C23 16.55 22.55 17 22 17H14C13.45 17 13 16.55 13 16C13 15.45 13.45 15 14 15ZM10 19H12C12.55 19 13 19.45 13 20C13 20.55 12.55 21 12 21H10C9.45 21 9 20.55 9 20C9 19.45 9.45 19 10 19ZM14 19H22C22.55 19 23 19.45 23 20C23 20.55 22.55 21 22 21H14C13.45 21 13 20.55 13 20C13 19.45 13.45 19 14 19Z"
                                  fill="white" />
                        </svg>

                    </div>
                    <div class="flex flex-col">
                        <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('Start Time', BLOGINA_TEXT_DOMAIN); ?></h4>
                        <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo BLOGINA_Course::get_course_start(); ?></span>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if($show_end_date): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
                <div class="flex items-center gap-x-4 w-full">
                    <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 32" fill="none">
                            <path opacity="0.4"
                                  d="M22 4H10C7.79 4 6 5.79 6 8V24C6 26.21 7.79 28 10 28H22C24.21 28 26 26.21 26 24V8C26 5.79 24.21 4 22 4Z"
                                  fill="white" />
                            <path d="M22 2C22.55 2 23 2.45 23 3V5C23 5.55 22.55 6 22 6C21.45 6 21 5.55 21 5V3C21 2.45 21.45 2 22 2ZM10 2C10.55 2 11 2.45 11 3V5C11 5.55 10.55 6 10 6C9.45 6 9 5.55 9 5V3C9 2.45 9.45 2 10 2Z"
                                  fill="white" />
                            <path d="M6 10H26V24C26 26.21 24.21 28 22 28H10C7.79 28 6 26.21 6 24V10ZM10 15H12C12.55 15 13 15.45 13 16C13 16.55 12.55 17 12 17H10C9.45 17 9 16.55 9 16C9 15.45 9.45 15 10 15ZM14 15H22C22.55 15 23 15.45 23 16C23 16.55 22.55 17 22 17H14C13.45 17 13 16.55 13 16C13 15.45 13.45 15 14 15ZM10 19H12C12.55 19 13 19.45 13 20C13 20.55 12.55 21 12 21H10C9.45 21 9 20.55 9 20C9 19.45 9.45 19 10 19ZM14 19H22C22.55 19 23 19.45 23 20C23 20.55 22.55 21 22 21H14C13.45 21 13 20.55 13 20C13 19.45 13.45 19 14 19Z"
                                  fill="white" />
                        </svg>
                    </div>
                    <div class="flex flex-col">
                        <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('End Time', BLOGINA_TEXT_DOMAIN); ?></h4>
                        <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo BLOGINA_Course::get_course_end(); ?></span>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if($show_course_duration): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
                <div class="flex items-center gap-x-4 w-full">
                    <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 32" fill="none">
                            <circle cx="16" cy="16" r="13.5" stroke="white" stroke-opacity="0.6" stroke-width="1.5" />
                            <path opacity="0.4"
                                  d="M16 8C15.4477 8 15 8.44772 15 9V16C15 16.2761 15.1119 16.5261 15.2929 16.7071L19.2929 20.7071C19.6834 21.0976 20.3166 21.0976 20.7071 20.7071C21.0976 20.3166 21.0976 19.6834 20.7071 19.2929L17 15.5858V9C17 8.44772 16.5523 8 16 8Z"
                                  fill="white" />
                            <path opacity="0.6"
                                  d="M16 2C8.8203 2 3 7.8203 3 15C3 22.1797 8.8203 28 16 28C23.1797 28 29 22.1797 29 15C29 7.8203 23.1797 2 16 2ZM16 26C9.92487 26 5 21.0751 5 15C5 8.92487 9.92487 4 16 4C22.0751 4 27 8.92487 27 15C27 21.0751 22.0751 26 16 26Z"
                                  fill="white" />
                        </svg>

                    </div>
                    <div class="flex flex-col">
                        <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('Duration', BLOGINA_TEXT_DOMAIN); ?></h4>
                        <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo BLOGINA_Course::get_course_duration(); ?></span>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if($show_chapter_counts): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
                <div class="flex items-center gap-x-4 w-full">
                    <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 32" fill="none">
                            <path opacity="0.4"
                                  d="M6 5C6 4.44772 6.44772 4 7 4H25C25.5523 4 26 4.44772 26 5V27C26 27.5523 25.5523 28 25 28H7C6.44772 28 6 27.5523 6 27V5Z"
                                  fill="white" />
                            <path d="M10 8H22C22.5523 8 23 8.44772 23 9C23 9.55228 22.5523 10 22 10H10C9.44772 10 9 9.55228 9 9C9 8.44772 9.44772 8 10 8ZM10 14H22C22.5523 14 23 14.4477 23 15C23 15.5523 22.5523 16 22 16H10C9.44772 16 9 15.5523 9 15C9 14.4477 9.44772 14 10 14ZM10 20H16C16.5523 20 17 20.4477 17 21C17 21.5523 16.5523 22 16 22H10C9.44772 22 9 21.5523 9 21C9 20.4477 9.44772 20 10 20Z"
                                  fill="white" />
                            <path d="M4 5C4 3.34315 5.34315 2 7 2H25C26.6569 2 28 3.34315 28 5V27C28 28.6569 26.6569 30 25 30H7C5.34315 30 4 28.6569 4 27V5ZM7 4C6.44772 4 6 4.44772 6 5V27C6 27.5523 6.44772 28 7 28H25C25.5523 28 26 27.5523 26 27V5C26 4.44772 25.5523 4 25 4H7Z"
                                  fill="none" />
                        </svg>
                    </div>
                    <div class="flex flex-col">
                        <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('Chapter Count', BLOGINA_TEXT_DOMAIN); ?></h4>
                        <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo BLOGINA_Course::get_course_chapter_count(); ?></span>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if($show_session_counts): ?>
            <div class="<?php echo $show_as_slider ? 'swiper-slide': ''; ?> w-full bg-[#F1F4F7] md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] py-4 flex items-center !max-h-[113px] !min-h-[113px] px-6">
                <div class="flex items-center gap-x-4 w-full">
                    <div class="bg-[var(--blg-color-primary500)] rounded-md p-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 32" fill="none">
                            <path opacity="0.4"
                                  d="M8 4H24C26.21 4 28 5.79 28 8V24C28 26.21 26.21 28 24 28H8C5.79 28 4 26.21 4 24V8C4 5.79 5.79 4 8 4Z"
                                  fill="white" />
                            <path d="M16 8C15.45 8 15 8.45 15 9V15H11C10.45 15 10 15.45 10 16C10 16.55 10.45 17 11 17H16C16.55 17 17 16.55 17 16V9C17 8.45 16.55 8 16 8ZM11 20H21C21.55 20 22 20.45 22 21C22 21.55 21.55 22 21 22H11C10.45 22 10 21.55 10 21C10 20.45 10.45 20 11 20Z"
                                  fill="white" />
                        </svg>

                    </div>
                    <div class="flex flex-col">
                        <h4 class="text[var(--blg-color-primary500)] leading-8 font-semibold"><?php esc_html_e('Session Count', BLOGINA_TEXT_DOMAIN); ?></h4>
                        <span class="text-[var(--blg-gray)] font-normal text-[15px]"><?php echo BLOGINA_Course::get_course_session_count(); ?></span>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    <?php echo $show_as_slider ? '</div>' : '';?>
    <?php if($show_as_slider) : ?>
        <div class="single-details-pagination !flex !items-center !justify-center relative pt-8 blg-swiper-pagination "></div>
    <?php endif; ?>
</div>

<?php if($show_as_slider): ?>
    <script>
        new Swiper('.single-details-swiper-container', {
            loop: false,
            pagination: {
                el: '.single-details-pagination',
                clickable: true,
            },
            slidesPerView: 1,
            spaceBetween: 20,
            autoplay: {
                delay: 3000,
                disableOnInteraction: true,
                pauseOnMouseEnter: true,
            },
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 3,
                },
            },
        });
    </script>
<?php endif; ?>

