<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINA_Course $this */

global $product;

$post_id = get_the_ID();
?>
<div class="entry-content blg-single-entry-content bg-white gap-x-8 gap-y-2 p-6 my-10 blg-shadow-sm rounded-[var(--blg-radius-3xl)] overflow-hidden">
    <div class="flex justify-between items-center my-4">
        <div class="flex flex-col gap-y-2">
            <?php the_title('<h2 class="!text-xl !font-bold !m-0 !text-[var(--blg-color-primary500)]">', '</h2>'); ?> </h1>
            <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
            </div>
        </div>
    </div>
    <?php
    the_content(sprintf(
        wp_kses(__('Continue reading<span class="screen-reader-text"> "%s"</span>', BLOGINA_TEXT_DOMAIN), array(
            'span' => array(
                'class' => [],
            ),
        )),
        wp_kses_post(get_the_title())
    ));

    ?>

        <?php
            get_template_part('templates/single/course/categories');
            get_template_part('templates/single/course/tags');
        ?>
</div>
