<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINA_Course $this */

global $product;

$post_id = get_the_ID();
$sessions = BLOGINA_Course::get_sessions();

?>
<div id="chaptersModal" class="hidden fixed inset-0 bg-gray-800 bg-opacity-50 flex justify-center items-center z-50">
    <div class="bg-white w-4/5 h-full min-h-[70%] max-h-[80%] rounded-lg shadow-lg flex flex-col overflow-hidden">
        <!-- Close Button -->
        <div class="flex justify-between items-center border-b border-gray-200 p-4 my-1">
            <h2 class="text-xl font-bold text-gray-800"><?php esc_html_e('Course Sessions', BLOGINA_TEXT_DOMAIN); ?></h2>
            <button id="closeModal" class="text-gray-500 hover:text-gray-700">&times;</button>
        </div>
        <div class="flex flex-col lg:flex-row lg:gap-x-2 gap-y-2 h-full px-1">
            <!-- Sidebar -->
            <div class="lg:w-1/3 w-full border-l border-[var(--blg-color-primary400)] p-4 overflow-y-auto">
                <?php foreach ($sessions as $Modalkey => $sessions): ?>
                    <div class="blg-accordion flex flex-col gap-y-1 mt-2">

                        <div class="blg-accordion-item border-[1px] border-[var(--blg-color-primary100)] rounded-none">
                            <h3 class="blg-accordion-header">
                                <button aria-label="chapter title"
                                    class="blg-accordion-button flex justify-between rounded-none items-center w-full py-2 px-2 text-[var(--blg-color-primary500)] font-semibold text-[15px] transition-all duration-300"
                                    type="button"
                                    data-target="#blg-accordion-item-sessions-<?php echo $Modalkey; ?>-modal"
                                    aria-expanded="false">
                                    <?php echo esc_html($sessions['chapter_title']);
                                    ?>
                                    <span class="blg-accordion-icon text-xl">+</span>

                                </button>
                            </h3>
                            <div id="blg-accordion-item-sessions-<?php echo $Modalkey; ?>-modal"
                                class="blg-accordion-content border-t border-[var(--blg-color-primary400)] hidden px-2 py-2 text-[var(--blg-gray)] font-normal text-[15px]">
                                <?php if (!empty($sessions['sessions'])): ?>
                                    <?php foreach ($sessions['sessions'] as $session): ?>
                                        <div class="blg-session flex md:flex-row flex-col md:items-center items-start md:gap-y-0 gap-y-2 justify-between py-2">

                                            <h4 data-bought="<?php echo BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id); ?>"
                                                data-status="<?php echo esc_attr($session['status']); ?>"
                                                data-url="<?php echo ($session['status'] === 'locked' && !BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id)) ? '' : $session['url']; ?>"
                                                data-title="<?php echo esc_attr($session['title']); ?>"
                                                class="session-btn flex gap-x-2 items-center !justify-between w-full blg-session-title text-[var(--blg-gray)] text-[15px]">
                                                <?php
                                                printf(
                                                    '%s',
                                                    esc_html($session['title']),
                                                );
                                                ?> <?php if ($session['status'] === 'free' || BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id)): ?>
                                                    <div class="flex items-center justify-center w-8">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="25"
                                                            height="25" viewBox="0 0 25 25" fill="none">
                                                            <path opacity="0.4"
                                                                d="M12.254 17.3743C13.1542 17.3743 13.884 16.6445 13.884 15.7443C13.884 14.844 13.1542 14.1143 12.254 14.1143C11.3538 14.1143 10.624 14.844 10.624 15.7443C10.624 16.6445 11.3538 17.3743 12.254 17.3743Z"
                                                                fill="#3A4654" />
                                                            <path d="M16.9039 9.46436H7.60391C3.50391 9.46436 2.25391 10.7144 2.25391 14.8144V16.6744C2.25391 20.7744 3.50391 22.0244 7.60391 22.0244H16.9039C21.0039 22.0244 22.2539 20.7744 22.2539 16.6744V14.8144C22.2539 10.7144 21.0039 9.46436 16.9039 9.46436ZM12.2539 18.7644C10.5839 18.7644 9.23391 17.4044 9.23391 15.7444C9.23391 14.0844 10.5839 12.7244 12.2539 12.7244C13.9239 12.7244 15.2739 14.0844 15.2739 15.7444C15.2739 17.4044 13.9239 18.7644 12.2539 18.7644Z"
                                                                fill="#3A4654" />
                                                            <path opacity="0.4"
                                                                d="M7.37363 9.47441V8.30441C7.37363 5.37441 8.20363 3.42441 12.2536 3.42441C16.5836 3.42441 17.1336 4.84684 17.1336 6.52748C17.1336 6.91748 17.4436 7.22594 17.8336 7.22594C18.2236 7.22594 18.5336 7.01763 18.5336 6.62763C18.5336 3.57823 16.4236 2.02441 12.2536 2.02441C6.62363 2.02441 5.97363 5.60441 5.97363 8.30441V9.55441C6.39363 9.50441 6.86363 9.47441 7.37363 9.47441Z"
                                                                fill="#3A4654" />
                                                        </svg>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="rounded-lg flex items-center justify-center w-8">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="25"
                                                            height="25" viewBox="0 0 25 25" fill="none">
                                                            <path opacity="0.4"
                                                                d="M12.254 17.3743C13.1542 17.3743 13.884 16.6445 13.884 15.7443C13.884 14.844 13.1542 14.1143 12.254 14.1143C11.3538 14.1143 10.624 14.844 10.624 15.7443C10.624 16.6445 11.3538 17.3743 12.254 17.3743Z"
                                                                fill="#3A4654" />
                                                            <path d="M16.9039 9.46436H7.60391C3.50391 9.46436 2.25391 10.7144 2.25391 14.8144V16.6744C2.25391 20.7744 3.50391 22.0244 7.60391 22.0244H16.9039C21.0039 22.0244 22.2539 20.7744 22.2539 16.6744V14.8144C22.2539 10.7144 21.0039 9.46436 16.9039 9.46436ZM12.2539 18.7644C10.5839 18.7644 9.23391 17.4044 9.23391 15.7444C9.23391 14.0844 10.5839 12.7244 12.2539 12.7244C13.9239 12.7244 15.2739 14.0844 15.2739 15.7444C15.2739 17.4044 13.9239 18.7644 12.2539 18.7644Z"
                                                                fill="#3A4654" />
                                                            <path opacity="0.4"
                                                                d="M7.37363 9.47441V8.30441C7.37363 5.37441 8.20363 3.42441 12.2536 3.42441C16.3036 3.42441 17.1336 5.37441 17.1336 8.30441V9.47441C17.6436 9.48441 18.1036 9.50441 18.5336 9.56441V8.30441C18.5336 5.60441 17.8836 2.02441 12.2536 2.02441C6.62363 2.02441 5.97363 5.60441 5.97363 8.30441V9.55441C6.39363 9.50441 6.86363 9.47441 7.37363 9.47441Z"
                                                                fill="#3A4654" />
                                                        </svg>
                                                        </svg>
                                                    </div>
                                                <?php endif; ?>
                                            </h4>

                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p><?php esc_html_e('No sessions available for this chapter.', BLOGINA_TEXT_DOMAIN); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Content Area -->
            <div id="loadingIndicator" class="hidden">
                <div class="spinner-session"></div>
            </div>
            <div id="sessionContent" class="lg:w-2/3 h-full w-full p-6 relative">
                <h2 class="text-xl font-bold mb-4 blg-modal-session-title"></h2>
                <p class="text-gray-500 text-center">
                    <?php esc_html_e('Please select a session to view its content.', BLOGINA_TEXT_DOMAIN); ?>
                </p>
            </div>

        </div>
    </div>
</div>
