<?php

/**
 * Name: Type 1
 */
$display_logo = BLOGINA_Settings::get('blg_display_logo', true);
$display_account_icon = BLOGINA_Settings::get('blg_display_account_icon', true);
$display_search_icon = BLOGINA_Settings::get('blg_display_search_icon', true);
$display_cart_icon = BLOGINA_Settings::get('blg_display_cart_icon', true);
$display_phone_icon = BLOGINA_Settings::get('blg_display_phone_icon', true);
$display_phone_number = BLOGINA_Settings::get('blg_display_phone_number', true);
$display_phone_description = BLOGINA_Settings::get('blg_display_phone_description', true);
$fullwidth = BLOGINA_Settings::get('blg_site_width_style') === 'full-width';

?>
<header role="banner" id="masthead" class="site-header <?php echo $fullwidth && is_front_page() ? 'px-4': ''; ?>">
    <div class="items-center flex justify-between flex-row w-full py-2 header-main-section">
        <div class="flex items-center md:flex-row flex-col">
            <?php if ($display_logo): ?>
                <div class="site-branding">
                    <?php
                    if (has_custom_logo()) echo BLOGINA_Theme::logo();
                    else {
                        $blogname = get_bloginfo('name');
                        if (trim($blogname)) {
                            if ((is_front_page() or is_home()) and !is_page()) echo '<h1><a href="' . esc_url(home_url()) . '"><img alt="site-logo" width="100%" height="100%" src="' . BLOGINA_Settings::get('site_logo')['url'] . '"/></a></h1>';
                            else echo '<a href="' . esc_url(home_url()) . '"><img alt="site-logo" width="100%" height="100%" src="' . BLOGINA_Settings::get('site_logo')['url'] . '"/></a>';
                        }
                    }
                    ?>
                </div>
            <?php endif; ?>

            <nav class="main-navigation border-opacity-15 px-4 lg:flex hidden lg:items-center lg:justify-between" role="navigation" aria-label="<?php esc_attr_e('Primary', BLOGINA_TEXT_DOMAIN); ?>" id="site-navigation">
                <?php
                wp_nav_menu([
                    'theme_location' => 'menu-1',
                    'menu_class' => 'main-menu border-opacity-15 flex flex-col md:flex-row gap-y-4 md:gap-y-0 ',
                    'container' => 'nav',
                    'container_class' => 'main-menu-container',
                    'walker' => new BLOGINA_Custom_Nav_Walker() // Adding custom walker here
                ]);
                ?>
            </nav>
        </div>
        <div class="w-auto flex items-center">
            <div class="flex items-center justify-center lg:border-l-2 !border-none gap-x-4">
                <?php if ($display_search_icon): ?>
                    <!-- Search Icon -->
                    <span class="xl:flex hidden cursor-pointer" id="search-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                            <path opacity="0.4" d="M11.5 21.6777C16.7467 21.6777 21 17.4244 21 12.1777C21 6.93103 16.7467 2.67773 11.5 2.67773C6.25329 2.67773 2 6.93103 2 12.1777C2 17.4244 6.25329 21.6777 11.5 21.6777Z" fill="var(--blg-color-primary500)" />
                            <path d="M21.3001 22.6778C21.1201 22.6778 20.9401 22.6078 20.8101 22.4778L18.9501 20.6178C18.6801 20.3478 18.6801 19.9078 18.9501 19.6278C19.2201 19.3578 19.6601 19.3578 19.9401 19.6278L21.8001 21.4878C22.0701 21.7578 22.0701 22.1978 21.8001 22.4778C21.6601 22.6078 21.4801 22.6778 21.3001 22.6778Z" fill="var(--blg-color-primary500)" />
                        </svg>
                    </span>

                    <!-- Overlay Search Form -->
                    <div id="search-overlay" class="fixed inset-0 z-50 bg-[rgba(0,0,0,0.6)]">
                        <!-- Search Form -->
                        <div class="p-6 w-full max-w-[1024px] absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2">
                            <form method="get" action="<?php echo home_url(); ?>/" class="flex w-full">
                                <input type="text" name="s" placeholder="<?php echo esc_html_e('search', BLOGINA_TEXT_DOMAIN); ?>" class="p-4 w-full bg-transparent rounded-none text-center font-medium text-3xl text-white border-b-2 border-white focus:border-none focus:outline-none" required>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if ($display_account_icon): ?>

                    <?php $my_account_url = wc_get_account_endpoint_url('dashboard'); ?>
                    <a aria-label="my account link" href="<?php echo esc_url($my_account_url); ?>" class="py-[10px] px-3 border border-solid border-[rgba(58, 70, 84, 1)] rounded-[var(--blg-radius-lg)]">
                        <span class="">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                <path opacity="0.4" d="M12 2.67773C9.38 2.67773 7.25 4.80773 7.25 7.42773C7.25 9.99773 9.26 12.0777 11.88 12.1677C11.96 12.1577 12.04 12.1577 12.1 12.1677C12.12 12.1677 12.13 12.1677 12.15 12.1677C12.16 12.1677 12.16 12.1677 12.17 12.1677C14.73 12.0777 16.74 9.99773 16.75 7.42773C16.75 4.80773 14.62 2.67773 12 2.67773Z" fill="var(--blg-color-primary500)" />
                                <path d="M17.08 14.8277C14.29 12.9677 9.73996 12.9677 6.92996 14.8277C5.65996 15.6777 4.95996 16.8277 4.95996 18.0577C4.95996 19.2877 5.65996 20.4277 6.91996 21.2677C8.31996 22.2077 10.16 22.6777 12 22.6777C13.84 22.6777 15.68 22.2077 17.08 21.2677C18.34 20.4177 19.04 19.2777 19.04 18.0377C19.03 16.8077 18.34 15.6677 17.08 14.8277Z" fill="var(--blg-color-primary500)" />
                            </svg>
                        </span>
                    </a>
                <?php endif; ?>
                <?php if ($display_cart_icon): ?>

                    <button id="cart-toggle" class="py-[10px] px-3 border border-solid border-[rgba(58, 70, 84, 1)] rounded-[var(--blg-radius-lg)] text-white relative">

                        <span id="cart-count" class="absolute -right-2 top-2 transform -translate-y-1/2 bg-[var(--blg-color-secondary200)] text-white text-[10px] font-bold px-1.5 py-0.5 rounded-full">
                            <?php echo WC()->cart->get_cart_contents_count(); ?>
                        </span>
                        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path opacity="0.4" d="M16.0337 4.64997H15.7003L12.8837 1.8333C12.6587 1.6083 12.292 1.6083 12.0587 1.8333C11.8337 2.0583 11.8337 2.42497 12.0587 2.6583L14.0503 4.64997H5.95032L7.94199 2.6583C8.16699 2.4333 8.16699 2.06663 7.94199 1.8333C7.71699 1.6083 7.35032 1.6083 7.11699 1.8333L4.30866 4.64997H3.97533C3.22533 4.64997 1.66699 4.64997 1.66699 6.7833C1.66699 7.59163 1.83366 8.12497 2.18366 8.47497C2.38366 8.6833 2.62533 8.79163 2.88366 8.84997C3.12533 8.9083 3.38366 8.91663 3.63366 8.91663H16.367C16.6253 8.91663 16.867 8.89997 17.1003 8.84997C17.8003 8.6833 18.3337 8.1833 18.3337 6.7833C18.3337 4.64997 16.7753 4.64997 16.0337 4.64997Z" fill="var(--blg-color-primary500)" />
                            <path d="M16.3755 8.91676H3.63379C3.38379 8.91676 3.12546 8.90843 2.88379 8.8501L3.93379 15.2501C4.16712 16.6834 4.79212 18.3334 7.56712 18.3334H12.2421C15.0505 18.3334 15.5505 16.9251 15.8505 15.3501L17.1088 8.8501C16.8755 8.9001 16.6255 8.91676 16.3755 8.91676ZM8.84212 14.3001C8.84212 14.6251 8.58379 14.8834 8.25879 14.8834C7.93379 14.8834 7.67546 14.6251 7.67546 14.3001V11.5501C7.67546 11.2251 7.93379 10.9668 8.25879 10.9668C8.58379 10.9668 8.84212 11.2251 8.84212 11.5501V14.3001ZM12.4088 14.3001C12.4088 14.6251 12.1505 14.8834 11.8255 14.8834C11.5005 14.8834 11.2421 14.6251 11.2421 14.3001V11.5501C11.2421 11.2251 11.5005 10.9668 11.8255 10.9668C12.1505 10.9668 12.4088 11.2251 12.4088 11.5501V14.3001Z" fill="var(--blg-color-primary500)" />
                        </svg>
                    </button>
                <?php endif; ?>
                <!-- Sidebar Toggle and Additional Info -->
                <div class="flex items-center gap-x-4 lg:hidden">
                    <button aria-label="toggle sidebar" id="toggleSidebar" class="toggle-btn text-gray-700">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33" fill="none">
                            <path opacity="0.4" d="M29.3333 11.6772V5.62383C29.3333 3.74383 28.48 2.98383 26.36 2.98383H20.9733C18.8533 2.98383 18 3.74383 18 5.62383V11.6638C18 13.5572 18.8533 14.3038 20.9733 14.3038H26.36C28.48 14.3172 29.3333 13.5572 29.3333 11.6772Z" fill="#3A4654" />
                            <path d="M29.3333 26.6771V21.2905C29.3333 19.1705 28.48 18.3171 26.36 18.3171H20.9733C18.8533 18.3171 18 19.1705 18 21.2905V26.6771C18 28.7971 18.8533 29.6505 20.9733 29.6505H26.36C28.48 29.6505 29.3333 28.7971 29.3333 26.6771Z" fill="#3A4654" />
                            <path d="M13.9998 11.6772V5.62383C13.9998 3.74383 13.1465 2.98383 11.0265 2.98383H5.63984C3.51984 2.98383 2.6665 3.74383 2.6665 5.62383V11.6638C2.6665 13.5572 3.51984 14.3038 5.63984 14.3038H11.0265C13.1465 14.3172 13.9998 13.5572 13.9998 11.6772Z" fill="#3A4654" />
                            <path opacity="0.4" d="M13.9998 26.6771V21.2905C13.9998 19.1705 13.1465 18.3171 11.0265 18.3171H5.63984C3.51984 18.3171 2.6665 19.1705 2.6665 21.2905V26.6771C2.6665 28.7971 3.51984 29.6505 5.63984 29.6505H11.0265C13.1465 29.6505 13.9998 28.7971 13.9998 26.6771Z" fill="#3A4654" />
                        </svg>
                    </button>
                </div>
            </div>
            <a class="xl:flex hidden" aria-label="phone link" href="tel:<?php echo BLOGINA_Settings::get('blg_phone_number'); ?>">
                <div class="flex items-center pr-6 gap-x-2">
                    <div class="flex flex-col gap-y-[4px] text-left">
                        <?php if ($display_phone_number): ?>
                            <span class="text-[var(--blg-color-primary500)] text-lg font-bold whitespace-nowrap"><?php echo BLOGINA_Settings::get('blg_phone_number'); ?></span>
                        <?php endif; ?>
                        <?php if ($display_phone_description): ?>
                            <span class="text-[var(--blg-color-primary300)] text-[15px] font-normal">همراه ما باشید</span>
                        <?php endif; ?>
                    </div>
                    <?php if ($display_phone_icon): ?>
                        <div class="py-[10px] px-3 bg-[var(--blg-color-primary500)] rounded-[var(--blg-radius-lg)]">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                <path d="M17.62 11.4277C17.19 11.4277 16.85 11.0777 16.85 10.6577C16.85 10.2877 16.48 9.51771 15.86 8.84771C15.25 8.19771 14.58 7.81771 14.02 7.81771C13.59 7.81771 13.25 7.46771 13.25 7.04771C13.25 6.62771 13.6 6.27771 14.02 6.27771C15.02 6.27771 16.07 6.81771 16.99 7.78771C17.85 8.69771 18.4 9.82771 18.4 10.6477C18.4 11.0777 18.05 11.4277 17.62 11.4277Z" fill="white" />
                                <path d="M21.2298 11.4277C20.7998 11.4277 20.4598 11.0777 20.4598 10.6577C20.4598 7.10773 17.5698 4.22773 14.0298 4.22773C13.5998 4.22773 13.2598 3.87773 13.2598 3.45773C13.2598 3.03773 13.5998 2.67773 14.0198 2.67773C18.4198 2.67773 21.9998 6.25773 21.9998 10.6577C21.9998 11.0777 21.6498 11.4277 21.2298 11.4277Z" fill="white" />
                                <path opacity="0.4" d="M11.79 14.8877L8.52 18.1577C8.16 17.8377 7.81 17.5077 7.47 17.1677C6.44 16.1277 5.51 15.0377 4.68 13.8977C3.86 12.7577 3.2 11.6177 2.72 10.4877C2.24 9.34773 2 8.25773 2 7.21773C2 6.53773 2.12 5.88773 2.36 5.28773C2.6 4.67773 2.98 4.11773 3.51 3.61773C4.15 2.98773 4.85 2.67773 5.59 2.67773C5.87 2.67773 6.15 2.73773 6.4 2.85773C6.66 2.97773 6.89 3.15773 7.07 3.41773L9.39 6.68773C9.57 6.93773 9.7 7.16773 9.79 7.38773C9.88 7.59773 9.93 7.80773 9.93 7.99773C9.93 8.23773 9.86 8.47773 9.72 8.70773C9.59 8.93773 9.4 9.17773 9.16 9.41773L8.4 10.2077C8.29 10.3177 8.24 10.4477 8.24 10.6077C8.24 10.6877 8.25 10.7577 8.27 10.8377C8.3 10.9177 8.33 10.9777 8.35 11.0377C8.53 11.3677 8.84 11.7977 9.28 12.3177C9.73 12.8377 10.21 13.3677 10.73 13.8977C11.09 14.2477 11.44 14.5877 11.79 14.8877Z" fill="white" />
                                <path d="M21.9701 19.0078C21.9701 19.2878 21.9201 19.5778 21.8201 19.8578C21.7901 19.9378 21.7601 20.0178 21.7201 20.0978C21.5501 20.4578 21.3301 20.7978 21.0401 21.1178C20.5501 21.6578 20.0101 22.0478 19.4001 22.2978C19.3901 22.2978 19.3801 22.3078 19.3701 22.3078C18.7801 22.5478 18.1401 22.6778 17.4501 22.6778C16.4301 22.6778 15.3401 22.4378 14.1901 21.9478C13.0401 21.4578 11.8901 20.7978 10.7501 19.9678C10.3601 19.6778 9.9701 19.3878 9.6001 19.0778L12.8701 15.8078C13.1501 16.0178 13.4001 16.1778 13.6101 16.2878C13.6601 16.3078 13.7201 16.3378 13.7901 16.3678C13.8701 16.3978 13.9501 16.4078 14.0401 16.4078C14.2101 16.4078 14.3401 16.3478 14.4501 16.2378L15.2101 15.4878C15.4601 15.2378 15.7001 15.0478 15.9301 14.9278C16.1601 14.7878 16.3901 14.7178 16.6401 14.7178C16.8301 14.7178 17.0301 14.7578 17.2501 14.8478C17.4701 14.9378 17.7001 15.0678 17.9501 15.2378L21.2601 17.5878C21.5201 17.7678 21.7001 17.9778 21.8101 18.2278C21.9101 18.4778 21.9701 18.7278 21.9701 19.0078Z" fill="white" />
                            </svg>
                        </div>
                    <?php endif; ?>
                </div>
            </a>
        </div>
    </div>
    <div class="bg-[var(--blg-color-primary500)] !h-[0.5px] opacity-15"></div>


    <!-- Sidebar Menu -->
    <div class="mobile-menu-sidebar">
        <div id="mobile-menu-sidebar" class="mobile-side lg:hidden">
            <div class="sidebar-content">
                <div class="py-4 border-b border-[var(--blg-color-primary100)] px-4 flex items-center justify-between">
                    <div class="site-branding">
                        <?php
                        if (has_custom_logo()) echo BLOGINA_Theme::logo();
                        else {
                            $blogname = get_bloginfo('name');
                            if (trim($blogname)) {
                                if ((is_front_page() or is_home()) and !is_page()) echo '<h1><a href="' . esc_url(home_url()) . '"><img alt="site-logo" width="100%" height="100%" src="' . BLOGINA_Settings::get('site_logo')['url'] . '"/></a></h1>';
                                else echo '<a href="' . esc_url(home_url()) . '"><img alt="site-logo" width="100%" height="100%" src="' . BLOGINA_Settings::get('site_logo')['url'] . '"/></a>';
                            }
                        }
                        ?>
                    </div>
                    <button aria-label="toggle sidebar close" id="toggle-sidebar-close" class="text-gray-700 p-2 rounded">
                        ✕
                    </button>

                </div>
                <div class="flex flex-col justify-between gap-y-12">
                    <div>
                        <?php
                        // Check if the menu exists before displaying it
                        if (has_nav_menu('menu-1')) {
                            wp_nav_menu(array(
                                'theme_location' => 'menu-1',
                                'menu_id'        => 'sidebar-menu',
                                'container'      => false,
                                'menu_class'     => 'flex flex-col md:p-4 p-0',
                                'walker'         => new BLOGINA_Custom_Nav_Walker(),
                            ));
                        }
                        ?>
                    </div>
                </div>
                <div class="footer-menu-mobile">
                    <div class="bg-[var(--blg-color-primary400)] text-[var(--blg-color-primary500)] text-xs font-semibold text-center flex flex-col gap-y-3 rounded-[10px] py-8 m-2">
                        <span><?php echo BLOGINA_Settings::get('blg_phone_number'); ?></span>
                        <span>پشتیبان شما هستیم</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="mini-cart-sidebar">
        <?php woocommerce_mini_cart(); ?>
    </div>
</header>
