<?php

/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Listdomer
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header role="banner" class="entry-header <?php if (is_account_page() || is_front_page()) echo 'hidden'; ?>">
		<div class="w-full mb-6 mt-10">
			<div class="flex justify-between items-center">
				<div class="flex flex-col gap-y-2">
					<?php the_title('<h1 class="entry-title text-xl font-bold text-[var(--blg-color-primary500)]">', '</h1>'); ?>
					<div class="h-[1px] bg-[#E4E4E4] w-full relative">
						<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
					</div>
				</div>
			</div>
		</div>
	</header>

	<?php BLOGINA_POST::thumbnail(); ?>

	<div class="entry-content">
		<?php
		the_content();

		wp_link_pages(array(
			'before' => '<div class="page-links">' . esc_html__('Pages:', BLOGINA_TEXT_DOMAIN),
			'after'  => '</div>',
		));
		?>
	</div>

</article>