<?php

/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blogina
 */
?>

<section class="no-results not-found w-full bg-white shadow-md rounded-[var(--blg-radius-lg)] p-8 md:p-12">
    <header role="banner" class="page-header mb-6 text-center">
        <svg xmlns="http://www.w3.org/2000/svg" class="w-12 h-12 mx-auto mb-4 text-gray-500" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <path d="M21 15.5V21H3V15.5M3 12l9-9 9 9M12 3v12" />
        </svg>
        <h1 class="page-title text-2xl font-bold text-gray-800"><?php esc_html_e('Nothing Found', BLOGINA_TEXT_DOMAIN); ?></h1>
    </header>

    <div class="page-content text-gray-700">
        <?php
        if (is_home() && current_user_can('publish_posts')):

            printf(
                '<p class="text-lg">' . wp_kses(
                    /* translators: 1: link to WP admin new post page. */
                    __('Ready to publish your first post? <a href="%1$s" class="text-blue-500 hover:underline">Get started here</a>.', BLOGINA_TEXT_DOMAIN),
                    array(
                        'a' => array(
                            'href' => [],
                            'class' => [],
                        ),
                    )
                ) . '</p>',
                esc_url(admin_url('post-new.php'))
            );

        elseif (is_search()):
        ?>

            <p class="text-lg"><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', BLOGINA_TEXT_DOMAIN); ?></p>
        <?php
            get_search_form();

        else:
        ?>

            <p class="text-lg"><?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', BLOGINA_TEXT_DOMAIN); ?></p>
        <?php
            get_search_form();

        endif;
        ?>
    </div>
</section>