<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Blogina
 */
get_header();
do_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

?>
<div id="content" class="site-content">
	<?php if (is_single()): ?>
		<div class="w-full mb-6 mt-10">
			<div class="flex justify-between items-center">
				<div class="flex flex-col gap-y-2">
					<?php the_title('<h1 class="lg:text-xl text-lg font-bold text-[var(--blg-color-primary500)]"">', '</h1>'); ?>
					<div class="h-[1px] bg-[#E4E4E4] w-full relative">
						<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
					</div>
				</div>
			</div>
		</div>
	<?php endif; ?>
	<div class="grid grid-cols-12 lg:gap-x-6 py-4 gap-y-4">
		<?php $sidebar = BLOGINA_Settings::get('blg_single_post_layout'); ?>
		<div class="<?php echo ($sidebar == 'sidebar-right') ? 'order-2' : ''; ?> <?php echo (is_active_sidebar('single-post-sidebar') && $sidebar != 'full-width') ? 'lg:col-span-8' : ''; ?> col-span-12">
			<main role="main">
				<?php
				while (have_posts()) {
					the_post();

					get_template_part('templates/content', get_post_type());
				}
                wp_reset_postdata();
                ?>
			</main>
		</div>

		<?php if ($sidebar != 'full-width') : ?>
			<div class="lg:col-span-4 <?php echo ($sidebar == 'sidebar-right') ? 'order-1' : ''; ?> col-span-12">
				<div class="<?php echo BLOGINA_Settings::get('blg_single_blog_sticky_sidebar') ? 'blg-sticky-sidebar':'' ; ?>">
					<?php if (is_active_sidebar('single-post-sidebar')) : ?>
						<?php dynamic_sidebar('single-post-sidebar'); ?>
					<?php endif; ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
</div>
<?php
if (comments_open() || get_comments_number()) {
	comments_template();
}
?>
<?php if (BLOGINA_Settings::get('blg_single_show_related_posts')) : ?>
	<div class="blg-recent">
		<div class="w-full mb-6 mt-10">
			<div class="flex justify-between items-center">
				<div class="flex flex-col gap-y-2">
					<h4 class="lg:text-lg text-md font-bold text-[var(--blg-color-primary500)]">
						<?php echo esc_html__('Recent Posts', BLOGINA_TEXT_DOMAIN); ?>
					</h4>
					<div class="h-[1px] bg-[#E4E4E4] w-full relative">
						<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
					</div>
				</div>
			</div>
		</div>
		<?php echo do_shortcode('[blogina-recent-posts post_type="post" number="4" orderby="date" order="DESC"]'); ?>
	</div>
<?php endif; ?>
<?php
get_footer();
