<?php

/**
 * The search form template
 *
 * @package blogina
 */
?>

<form role="search" method="get" class="flex items-center space-x-2" action="<?php echo esc_url(home_url('/')); ?>">
    <label for="search-field" class="sr-only"><?php echo esc_html_x('Search for:', 'label', BLOGINA_TEXT_DOMAIN); ?></label>
    <input type="search" id="search-field" name="s" class="w-full p-2 border border-gray-300 rounded-[var(--blg-radius-md)] focus:outline-none focus:ring-2 focus:ring-primary-500" placeholder="<?php echo esc_attr_x('Search...', 'placeholder', BLOGINA_TEXT_DOMAIN); ?>" value="<?php echo get_search_query(); ?>" />
    <button aria-label="search" type="submit" class="px-4 py-2 text-white bg-primary-500 rounded-[var(--blg-radius-md)] hover:bg-primary-600 focus:outline-none focus:ring-2 focus:ring-primary-500">
        <?php echo esc_html_x('Search', 'submit button', BLOGINA_TEXT_DOMAIN); ?>
    </button>
</form>