<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Blogina
 */
get_header();
do_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

?>
<div id="content" class="site-content mx-auto px-4 py-8">
	<div class="flex items-center justify-center">
		<div class="text-center">
			<img width="962" height="687" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/404.png" alt="<?php esc_attr_e('Not Found Page', BLOGINA_TEXT_DOMAIN); ?>" class="mx-auto mb-6 object-cover" />

			<div class="page-content flex flex-col items-center justify-center gap-y-4">
				<div class="flex flex-col gap-y-2">
					<h4 class="font-['Pinar'] font-extrabold md:text-2xl text-xl text-[var(--blg-color-primary500)]">
						<?php esc_html_e('Your Page Not Found', BLOGINA_TEXT_DOMAIN); ?>
					</h4>
					<span class="text-[var(--blg-gray)] font-medium">
						<?php esc_html_e('This page may have been deleted or not exist', BLOGINA_TEXT_DOMAIN); ?>
					</span>
				</div>
				<div class="flex items-center justify-center gap-x-2 mt-4 font-['YekanBakh']">
					<a class="blg-btn-secondary-empty md:text-base text-xs text-[var(--blg-color-secondary200)] font-normal" href="<?php echo esc_url(home_url()); ?>">
						<?php esc_html_e('Previous Page', BLOGINA_TEXT_DOMAIN); ?>
					</a>
					<a class="blg-btn-secondary md:text-base text-xs text-white font-normal" href="<?php echo esc_url(home_url()); ?>">
						<?php esc_html_e('Return to the home page', BLOGINA_TEXT_DOMAIN); ?>
					</a>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
get_footer();
?>