<?php
// no direct access
defined('ABSPATH') || die();

if (is_user_logged_in()) {
    $logout_url = wp_logout_url(home_url());

    echo '
                    <div class="my-4 !rounded-[var(--blg-radius-3xl)] p-6 shadow-lg bg-white flex flex-col items-center">
                        <p class="text-lg font-semibold text-gray-800 mb-4">' . __('You are already logged in.', BLOGINAC_TEXT_DOMAIN) . '</p>
                        <a href="' . esc_url($logout_url) . '" class="!bg-red-500 !hover:bg-red-600 text-[var(--blg-color-primary500)] font-bold py-2 px-4 rounded-[var(--blg-radius-lg)] transition duration-200">
                            ' . __('Log Out', BLOGINAC_TEXT_DOMAIN) . '
                        </a>
                    </div>
                ';
                return;
}

$assets = new BLOGINAC_Assets();
$assets->footer('<script>
    jQuery(document).ready(function()
    {
        jQuery("#blogina-login-form").BloginaLoginForm({
            ajax_url: "' . admin_url('admin-ajax.php') . '",
            nonce: "' . wp_create_nonce('blg_login') . '"
        });
    });
    </script>');

$register_page = get_posts([
    'post_type' => 'page',
    'posts_per_page' => 1,
    's' => 'blogina-register',
]);

if (!empty($register_page)) $register_page_url = get_permalink($register_page[0]->ID);
else $register_page_url = wp_registration_url();
$display_image_section = BLOGINAC_Settings::get('blg_display_logister_image');
?>
<div class="xl:w-9/12 max-w-[997px] h-full w-full mx-auto bg-white blg-shadow-sm rounded-[var(--blg-radius-3xl)] py-8 md:px-8 px-4 my-2">
    <div class="grid lg:grid-cols-8 grid-cols-1 gap-x-8">
        <div class="<?php echo $display_image_section ? 'col-span-4':'col-span-8'; ?>" id="blg_login_wrapper">
            <form id="blogina-login-form" class="flex flex-col h-full gap-y-2 justify-between">
                <div id="blg_login_form_message"></div>
                <div class="flex flex-col gap-y-8">
                    <div class="w-full py-2">
                        <div class="flex justify-between items-center">
                            <div class="flex flex-col gap-y-2">
                                <h3 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php _e('Login to Portal', BLOGINAC_TEXT_DOMAIN); ?></h3>
                                <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                                    <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-[var(--blg-color-primary500)] text-[15px] font-semibold">لطفا نام کاربری (ایمیل) و رمز عبور خود را جهت ورود به پنل کاربری خود وارد کنید</div>

                    <div class="form-group flex flex-col gap-y-2">
                        <?php
                        echo BLOGINAC_Form::label([
                            'for' => 'blg_username',
                            'required' => true,
                            'title' => 'نام کاربری یا ایمیل',
                            'class' => 'font-[YekanBakh] text-[15px] text-[#78818D]',
                        ]);
                        ?>
                        <div class="relative flex items-center">
                            <span class="absolute !left-3 top-1/2 transform -translate-y-1/2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                    <path opacity="0.4" d="M2 13.0415V7.0615C2 4.3015 4.24 2.0715 7 2.0715H17C19.76 2.0715 22 4.3015 22 7.0615V14.0415C22 16.7915 19.76 19.0215 17 19.0215H15.5C15.19 19.0215 14.89 19.1715 14.7 19.4215L13.2 21.4115C12.54 22.2915 11.46 22.2915 10.8 21.4115L9.3 19.4215C9.14 19.2015 8.78 19.0215 8.5 19.0215H7C4.24 19.0215 2 16.7915 2 14.0415V13.0415Z" fill="var(--blg-color-primary500)" />
                                    <path d="M12 12.0715C11.44 12.0715 11 11.6215 11 11.0715C11 10.5215 11.45 10.0715 12 10.0715C12.55 10.0715 13 10.5215 13 11.0715C13 11.6215 12.56 12.0715 12 12.0715Z" fill="var(--blg-color-primary500)" />
                                    <path d="M16 12.0715C15.44 12.0715 15 11.6215 15 11.0715C15 10.5215 15.45 10.0715 16 10.0715C16.55 10.0715 17 10.5215 17 11.0715C17 11.6215 16.56 12.0715 16 12.0715Z" fill="var(--blg-color-primary500)" />
                                    <path d="M8 12.0715C7.44 12.0715 7 11.6215 7 11.0715C7 10.5215 7.45 10.0715 8 10.0715C8.55 10.0715 9 10.5215 9 11.0715C9 11.6215 8.56 12.0715 8 12.0715Z" fill="var(--blg-color-primary500)" />
                                </svg>
                            </span>

                            <?php echo BLOGINAC_Form::text([
                                'id' => 'blg_username',
                                'name' => 'log',
                                'placeholder' => esc_html__('name@example.com', BLOGINAC_TEXT_DOMAIN),
                                'class' => 'block font-[YekanBakh] text-[15px] rounded-[8px] text-[#D2D2D2]',
                                'required' => true,
                            ]); ?>
                        </div>

                    </div>

                    <div class="form-group flex flex-col gap-y-2">
                        <?php
                        echo BLOGINAC_Form::label([
                            'for' => 'blg_password',
                            'required' => true,
                            'title' => 'رمز ورود',
                            'class' => 'font-[YekanBakh] text-[15px] text-[#78818D]',
                        ]);
                        ?>
                        <div class="relative flex items-center">
                            <span class="absolute !left-3 top-1/2 transform -translate-y-1/2" onclick="togglePasswordVisibility('blg_password', this)">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                    <path opacity="0.4" d="M21.2496 9.22151C20.7596 8.44151 20.1996 7.74151 19.6196 7.11151L15.8496 10.8815C15.9696 11.2515 16.0396 11.6515 16.0396 12.0715C16.0396 14.3115 14.2296 16.1115 11.9996 16.1115C11.5796 16.1115 11.1796 16.0415 10.8096 15.9215L7.34961 19.3815C8.80961 20.2015 10.3896 20.6315 11.9996 20.6315C13.7796 20.6315 15.5096 20.1115 17.0896 19.1415C18.6696 18.1615 20.0896 16.7315 21.2496 14.9115C22.2496 13.3515 22.2496 10.7915 21.2496 9.22151Z" fill="var(--blg-color-primary500)" />
                                    <path d="M14.0196 10.0515L9.97965 14.0915C9.46965 13.5715 9.13965 12.8515 9.13965 12.0715C9.13965 10.5015 10.4196 9.21155 11.9996 9.21155C12.7796 9.21155 13.4996 9.54155 14.0196 10.0515Z" fill="var(--blg-color-primary500)" />
                                    <path opacity="0.4" d="M18.25 5.82153L14.86 9.21153C14.13 8.47153 13.12 8.03153 12 8.03153C9.76 8.03153 7.96 9.84153 7.96 12.0715C7.96 13.1915 8.41 14.2015 9.14 14.9315L5.76 18.3215H5.75C4.64 17.4215 3.62 16.2715 2.75 14.9115C1.75 13.3415 1.75 10.7915 2.75 9.22153C3.91 7.40153 5.33 5.97153 6.91 4.99153C8.49 4.03153 10.22 3.50153 12 3.50153C14.23 3.50153 16.39 4.32153 18.25 5.82153Z" fill="var(--blg-color-primary500)" />
                                    <path d="M14.8601 12.0716C14.8601 13.6416 13.5801 14.9316 12.0001 14.9316C11.9401 14.9316 11.8901 14.9316 11.8301 14.9116L14.8401 11.9016C14.8601 11.9616 14.8601 12.0116 14.8601 12.0716Z" fill="var(--blg-color-primary500)" />
                                    <path d="M21.7699 2.30154C21.4699 2.00154 20.9799 2.00154 20.6799 2.30154L2.22988 20.7615C1.92988 21.0615 1.92988 21.5515 2.22988 21.8515C2.37988 21.9915 2.56988 22.0715 2.76988 22.0715C2.96988 22.0715 3.15988 21.9915 3.30988 21.8415L21.7699 3.38154C22.0799 3.08154 22.0799 2.60154 21.7699 2.30154Z" fill="var(--blg-color-primary500)" />
                                </svg>
                            </span>

                            <?php echo BLOGINAC_Form::input([
                                'id' => 'blg_password',
                                'name' => 'pwd',
                                'placeholder' => esc_html__('Password', BLOGINAC_TEXT_DOMAIN),
                                'class' => 'block font-[YekanBakh] text-[15px] text-right rounded-[8px] text-[#D2D2D2]',
                                'required' => true,
                            ], 'password'); ?>
                        </div>
                    </div>
                    <?php BLOGINAC_Form::nonce('blg_login', 'blg_login'); ?>

                    <div class="flex items-center justify-between text-nowrap">
                        <div class="flex items-center text-sm gap-x-2">
                            <?php
                            echo BLOGINAC_Form::checkbox([
                                'id' => 'blg_rememberme',
                                'name' => 'rememberme',
                                'value' => 'forever',
                                'class' => 'block text-right',
                            ]);
                            echo BLOGINAC_Form::label([
                                'for' => 'blg_rememberme',
                                'title' => 'مرا بخاطر بسپار',
                                'class' => 'font-[YekanBakh] text-[15px] text-[#78818D]',
                            ]);
                            ?>
                        </div>
                        <a href="<?php echo esc_url(wp_lostpassword_url()); ?>" class="text-[15px] font-[YekanBakh] text-[var(--blg-color-primary500)] font-medium"><?php _e('Forgot your password?', BLOGINAC_TEXT_DOMAIN); ?></a>
                    </div>
                </div>

                <div class="flex flex-col gap-y-1 md:my-0 my-8">
                    <div>
                        <span class="text-[15px] text-[var(--blg-color-primary500)] font-medium"><?php _e('Registered?', BLOGINAC_TEXT_DOMAIN); ?></span>
                        <a href="<?php echo esc_url($register_page_url); ?>" class="text-sm text-[var(--blg-color-primary500)] font-medium"><?php _e('Register', BLOGINAC_TEXT_DOMAIN); ?></a>
                    </div>

                    <?php
                    echo BLOGINAC_Form::submit([
                        'label' => 'ورود',
                        'id' => 'blogina-login-submit',
                        'class' => 'blg-btn-secondary w-max flex !py-1.5 !px-4 gap-x-4 items-center',
                        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"><path d="M15.1695 10.2244V12.4494C15.1695 15.2078 13.2112 16.3411 10.8195 14.9578L8.89453 13.8411L6.96953 12.7244C4.57786 11.3411 4.57786 9.08276 6.96953 7.69943L8.89453 6.58276L10.8195 5.46609C13.2112 4.10776 15.1695 5.23276 15.1695 7.99943V10.2244Z" fill="var(--blg-color-secondary200)" /></svg>',
                    ], 'submit');
                    ?>
                </div>
            </form>
        </div>
        <?php if($display_image_section) : ?>
            <div class="lg:flex hidden col-span-4 bg-[var(--blg-color-primary500)] w-full h-full !max-h-[620px] rounded-[var(--blg-radius-xl)] py-[250px] lg:px-[140px] px-[60px]">
                <img width="100%" src="<?php echo BLOGINAC_Settings::get('blg_logister_logo')['url']; ?>" alt="">
            </div>
        <?php endif; ?>
    </div>
</div>
