<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Statistics')):

/**
 * Elementor Contact Info Box Widget.
 *
 * @class BLOGINAC_Elementor_Statistics
 * @version 1.0.0
 */
class BLOGINAC_Elementor_Statistics extends BLOGINAC_Elementor_Base
{
    public function get_name()
    {
        return 'bloginac-about-statistics';
    }

    public function get_title()
    {
        return __('Statistics', BLOGINAC_TEXT_DOMAIN);
    }

    public function get_icon()
    {
        return 'fas fa-chart-bar';
    }

    public function get_categories()
    {
        return ['blogina'];
    }

    protected function register_controls()
    {
        (new BLOGINAC_Controls_Statistics_Settings())->register_controls();
        (new BLOGINAC_Controls_Statistics_Style())->register_controls();
    }
    

    protected function render()
    {
        $settings = $this->get_settings_for_display();
    
        ?>
        <div class="py-6 lg:px-[70px] px-4 !rounded-[var(--blg-radius-xl)] bg-[var(--blg-bg-color-white)] blg-shadow-sm">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-10 items-center justify-center">
                <?php foreach ( $settings['statistics_list'] as $item ): ?>
                    <div class="flex items-center md:justify-center rounded-[var(--blg-radius-xl)] py-4 px-2 gap-x-3">
                        <div class="mr-1 blg-stats-icon">
                            <?php
                            // Render Font Awesome icon correctly
                            if (isset($item['icon']['value'])) {
                                \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => 'lg:w-6 lg:h-6 w-4 h-4 text-white']);
                            }
                            ?>
                        </div>
                        <div class="bg-[var(--blg-color-primary200)] w-[1px] h-[30px]"></div> 
                        <div class="lg:text-base text-sm font-medium flex flex-col text-[var(--blg-color-primary500)]">
                            <span class="font-extrabold blg-stats-num"><?php echo esc_html($item['number']); ?></span>
                            <span class="text-[#858585] blg-stats-desc">
                                <?php echo esc_html($item['description']); ?>
                            </span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }
    
    
}

endif;
