<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_ProgressBar')):

    /**
     * Elementor Progress Bar Widget.
     *
     * @class BLOGINAC_Elementor_ProgressBar
     * @version 1.0.0
     */
    class BLOGINAC_Elementor_ProgressBar extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-progress-bar';
        }

        public function get_title()
        {
            return __('Progress Bar', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-bars';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Progress Bar Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // Progress Bars (Repeater)
            $this->add_control(
                'progress_bars',
                [
                    'label' => __('Progress Bars', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => [
                        [
                            'name' => 'title',
                            'label' => __('Title', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => __('Skill Title', BLOGINAC_TEXT_DOMAIN),
                        ],
                        [
                            'name' => 'percentage',
                            'label' => __('Percentage', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'default' => [
                                'size' => 50,
                                'unit' => '%',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                        ],
                    ],
                    'default' => [
                        [
                            'title' => __('HTML', BLOGINAC_TEXT_DOMAIN),
                            'percentage' => ['size' => 80],
                        ],
                        [
                            'title' => __('CSS', BLOGINAC_TEXT_DOMAIN),
                            'percentage' => ['size' => 70],
                        ],
                    ],
                ]
            );

            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            // Title Typography
            $this->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __('Title Typography', BLOGINAC_TEXT_DOMAIN),
                    'selector' => '{{WRAPPER}} .bloginac-progress-bar-title',
                ]
            );

            // Bar Background Color
            $this->add_control(
                'bar_background_color',
                [
                    'label' => __('Bar Background Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#e0e0e0',
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-progress-bar-track' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            // Fill Color
            $this->add_control(
                'bar_fill_color',
                [
                    'label' => __('Bar Fill Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#ff6600',
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-progress-bar-fill' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            // Bar Height
            $this->add_control(
                'bar_height',
                [
                    'label' => __('Bar Height', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 5,
                            'max' => 50,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-progress-bar-track' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $progress_bars = $settings['progress_bars'];

            echo '<div class="bloginac-progress-bars-wrapper">';
            foreach ($progress_bars as $progress) {
                $title = $progress['title'];
                $percentage = $progress['percentage']['size'];

                echo '<div class="bloginac-progress-bar">';

                // Title
                echo '<div class="bloginac-progress-bar-title">' . esc_html($title) . ' (' . esc_html($percentage) . '%)</div>';

                // Progress Bar
                echo '<div class="bloginac-progress-bar-track">';
                echo '<div class="bloginac-progress-bar-fill" style="width: ' . esc_attr($percentage) . '%;">';

                // Display percentage inside the bar
                echo '<span class="bloginac-progress-bar-percentage">' . esc_html($percentage) . '%</span>';
                echo '</div>';
                echo '</div>';

                echo '</div>';
            }
            echo '</div>';
        }
    }

endif;
